#include <stdio.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>
#include <process.h>
#define INCL_DOS
#define INCL_DOSERRORS
#include <os2.h>

#define THREAD_STACK_SIZE 32768    // thread stack size in bytes

#include "dart.h"

void myerrorlog( const char *text, ... );

#define system_buflen SoundSys.nBufferSize

LONG APIENTRY DARTEvent ( ULONG ulStatus,
                        PMCI_MIX_BUFFER pBuffer,
                        ULONG ulFlags  )
{
  ULONG junk;

  switch( ulFlags )
  {
    case MIX_STREAM_ERROR | MIX_WRITE_COMPLETE: // error occurred in device
      SoundSys.MixSetupParms.pmixWrite( SoundSys.MixSetupParms.ulMixHandle,
       &(SoundSys.MixBuffers[SoundSys.ulBufferTail]), 1 );
    break;
    case MIX_WRITE_COMPLETE:           // for playback
      DosRequestMutexSem( SoundSys.semDARTMutex, SEM_INDEFINITE_WAIT );
      DosResetEventSem( SoundSys.semHasBuffer, &junk );

      if ( SoundSys.ulBufferTail == SoundSys.ulBufferHead )
      {
        DosReleaseMutexSem( SoundSys.semDARTMutex );
        if ( DosWaitEventSem( SoundSys.semHasBuffer, 1 ) 
              == ERROR_TIMEOUT )
        {
          DosRequestMutexSem( SoundSys.semDARTMutex, SEM_INDEFINITE_WAIT );
          SoundSys.ulBufferTail=(SoundSys.ulBufferTail-1) % SoundSys.ulNumBuffers;
          // hiccup on timeout
        } else {
          DosRequestMutexSem( SoundSys.semDARTMutex, SEM_INDEFINITE_WAIT );
        }
      }

      SoundSys.ulBufferTail=(SoundSys.ulBufferTail+1) % SoundSys.ulNumBuffers;

      SoundSys.MixSetupParms.pmixWrite( SoundSys.MixSetupParms.ulMixHandle,
       &(SoundSys.MixBuffers[SoundSys.ulBufferTail]), 1 );

      DosPostEventSem( SoundSys.semNeedsBuffer );
      DosReleaseMutexSem( SoundSys.semDARTMutex );

    break;
  }
  return( TRUE );
}

signed short *audio_cur_buffer;

static char alreadyinit = 0;

char DART_init( unsigned long frequency, unsigned long *bufferlen, 
   char bitspersample, char stereo, char shareaudio ) {

   MCI_AMP_OPEN_PARMS AmpOpenParms;
   ULONG rc, ulIndex;

   if ( alreadyinit ) {
        DART_shutdown();
        alreadyinit = 0;
   }

   /* clean the OS/2 driver state */
   memset(&SoundSys, 0, sizeof(SoundSys));

   if ( frequency == 0 ) frequency = 22050;
   if ( bitspersample == 0 ) bitspersample = 8;
   if ( *bufferlen == 0 ) *bufferlen = 2048;

   myerrorlog( "Audio startup: Freq %ld %d bit, %s.  Buffer size = %ld\n", frequency, bitspersample, (stereo ? "stereo" : "mono"), *bufferlen );

   SoundSys.depth = bitspersample;
   SoundSys.stereo = stereo;

   DosCreateMutexSem(NULL, &(SoundSys.semDARTMutex), 0, 0);
   DosCreateEventSem(NULL, &(SoundSys.semNeedsBuffer), DC_SEM_SHARED, 0);
   DosCreateEventSem(NULL, &(SoundSys.semHasBuffer), DC_SEM_SHARED, 0);

   /* open the mixer device
    */
   memset ( &AmpOpenParms, 0, sizeof ( MCI_AMP_OPEN_PARMS ) );

   AmpOpenParms.usDeviceID    = ( USHORT ) 0;
   AmpOpenParms.pszDeviceType = ( PSZ ) MCI_DEVTYPE_AUDIO_AMPMIX;
   AmpOpenParms.hwndCallback  = 0;

   rc = mciSendCommand( 0,
                       MCI_OPEN,
                       MCI_WAIT | MCI_OPEN_TYPE_ID | (shareaudio ? MCI_OPEN_SHAREABLE:0),
                       ( PVOID ) &AmpOpenParms,
                       0 );

   if ( rc != MCIERR_SUCCESS )
   {
      return( 1 );  // ERROR!
   }

   SoundSys.usDeviceID = AmpOpenParms.usDeviceID;

   /* Set the MixSetupParms data structure to match the loaded file.
    * This is a global that is used to setup the mixer.
    */
   memset( &(SoundSys.MixSetupParms), 0, sizeof( MCI_MIXSETUP_PARMS ) );

   SoundSys.MixSetupParms.ulBitsPerSample = bitspersample;
   SoundSys.MixSetupParms.ulFormatTag = MCI_WAVE_FORMAT_PCM;
   SoundSys.MixSetupParms.ulSamplesPerSec = frequency;
   SoundSys.MixSetupParms.ulChannels = (stereo ? 2 : 1);

   // Setup the mixer for playback of wave data

   SoundSys.MixSetupParms.ulFormatMode = MCI_PLAY;
   SoundSys.MixSetupParms.ulDeviceType = MCI_DEVTYPE_WAVEFORM_AUDIO;
   SoundSys.MixSetupParms.pmixEvent    = DARTEvent;

   SoundSys.MixSetupParms.ulBufferSize = *bufferlen;
   SoundSys.nBufferSize=SoundSys.MixSetupParms.ulBufferSize;

   rc = mciSendCommand( SoundSys.usDeviceID,
                        MCI_MIXSETUP,
                        MCI_WAIT | MCI_MIXSETUP_INIT,
                        ( PVOID ) &(SoundSys.MixSetupParms),
                        0 );

   if ( rc != MCIERR_SUCCESS )
   {
      return( 1 );  // ERROR!
   }

   if ( SoundSys.nBufferSize > SoundSys.MixSetupParms.ulBufferSize ) {
	// If DART suggests a smaller buffer size use the suggestion instead
	// otherwise, ignore the suggestion.

	SoundSys.nBufferSize=SoundSys.MixSetupParms.ulBufferSize;
	*bufferlen = SoundSys.nBufferSize;
   }

   SoundSys.ulNumBuffers = 4;
   // Force using only 4 buffers to avoid lag

   if (SoundSys.ulNumBuffers>MAX_BUFFERS) SoundSys.ulNumBuffers=MAX_BUFFERS;

   // Set up the BufferParms data structure and allocate
   // device buffers from the Amp-Mixer

   SoundSys.BufferParms.ulNumBuffers = SoundSys.ulNumBuffers;
   SoundSys.BufferParms.ulBufferSize = SoundSys.MixSetupParms.ulBufferSize;
   SoundSys.BufferParms.pBufList = &(SoundSys.MixBuffers);

   rc = mciSendCommand( SoundSys.usDeviceID,
                        MCI_BUFFER,
                        MCI_WAIT | MCI_ALLOCATE_MEMORY,
                        ( PVOID ) &(SoundSys.BufferParms),
                        0 );

    if ( rc != MCIERR_SUCCESS )
    {
      return( 1 );  // ERROR!
    }

   // Set up all device buffers
   for( ulIndex = 0; ulIndex < SoundSys.ulNumBuffers; ulIndex++)
   {
      if ( SoundSys.MixBuffers[ ulIndex ].pBuffer == NULL ) {
          return( 1 );  // ERROR!
      } else {
          memset(SoundSys.MixBuffers[ ulIndex ].pBuffer,0,SoundSys.nBufferSize);
          SoundSys.MixBuffers[ ulIndex ].ulBufferLength = SoundSys.nBufferSize;
      }
   }

   audio_cur_buffer = (signed short *) SoundSys.MixBuffers[SoundSys.ulBufferHead].pBuffer;

   SoundSys.MixBuffers[SoundSys.ulNumBuffers - 1].ulFlags = MIX_BUFFER_EOS;
   // Set the "end-of-stream" flag

   SoundSys.ulBufferHead = 2;

   // Must write at least two buffers to start mixer
   SoundSys.MixSetupParms.pmixWrite( SoundSys.MixSetupParms.ulMixHandle,
                         &(SoundSys.MixBuffers[SoundSys.ulBufferTail]),
                         2 );

   alreadyinit = 1;

   return( 0 );  // No error
}

char DART_shutdown(void) {
   MCI_GENERIC_PARMS    GenericParms = {0};
   ULONG                rc;

   if ( !alreadyinit ) return 1;  // ERROR!

   for ( rc=0; rc<SoundSys.ulNumBuffers; rc++ ) {
	SoundSys.MixBuffers[rc].ulFlags = MIX_BUFFER_EOS;
   }

   rc = mciSendCommand( SoundSys.usDeviceID,
                        MCI_STOP,
                        MCI_WAIT ,
                        ( PVOID )&GenericParms,
                        0 );

   if ( rc != MCIERR_SUCCESS )
   {
      return 1;  // ERROR!
   }

   rc = mciSendCommand( SoundSys.usDeviceID,
                        MCI_BUFFER,
                        MCI_WAIT | MCI_DEALLOCATE_MEMORY,
                        ( PVOID )&(SoundSys.BufferParms),
                        0 );

   if ( rc != MCIERR_SUCCESS )
   {
      return 1;  // ERROR!
   }

   rc = mciSendCommand( SoundSys.usDeviceID,
                        MCI_CLOSE,
                        MCI_WAIT ,
                        ( PVOID )&GenericParms,
                        0 );

   if ( rc != MCIERR_SUCCESS )
   {
      return 1;  // ERROR!
   }

  DosCloseEventSem(SoundSys.semNeedsBuffer);
  DosCloseEventSem(SoundSys.semHasBuffer);
  DosCloseMutexSem(SoundSys.semDARTMutex);

  memset( &SoundSys, 0, sizeof( SoundSys ) );

  return 0;  // No error
}

