#ifndef DART_H_INCLUDED
#define DART_H_INCLUDED

#include "xtramm.h"

#define MAX_BUFFERS 32		   // Max number of DART buffers to use

struct _SoundSys {
    ULONG   nBufferSize;        // DART buffer size
    HMTX    semDARTMutex;       // Mutex semaphore for manipulating DART
                                //   buffer head and tail
    HEV     semNeedsBuffer;     // Hungry for more
    HEV     semHasBuffer;
    MCI_OPEN_PARMS mop;

    char depth, stereo;
    unsigned short usDeviceID; /* DART Amp-mixer device ID   */
    ULONG ulBufferHead;        /* Current DART stream buffer */
    ULONG ulBufferTail;        /* DART stream buffer tail    */
    ULONG ulNumBuffers;        /* Number of DART buffers     */
    MCI_MIX_BUFFER       MixBuffers[MAX_BUFFERS]; /* Device buffers      */
    MCI_MIXSETUP_PARMS   MixSetupParms;           /* Mixer parameters    */
    MCI_BUFFER_PARMS     BufferParms;             /* Device buffer parms */
    char MixBufferStat[MAX_BUFFERS];
    // Stat of 1 means it has new valid data

} SoundSys;

char DART_init( unsigned long frequency, unsigned long *bufferlen, 
    char bitspersample, char stereo, char share );

char DART_shutdown(void);

#endif

