#define INCL_DOSSEMAPHORES
#define INCL_WIN
#define INCL_GPI
#define INCL_DOSMISC
#define INCL_DOSPROCESS
#include <os2.h>
#include "resource.h"
#include "frontend.h"
#include "dualmode.h"
#include "scancode.h"
#include "options.h"
#include "profile.h"
#include "driver.h"
#include "audit.h"

#include <stdio.h>
#include <stdarg.h>
#include <string.h>
#include <malloc.h>
#include <stdlib.h>


#define LOG_ADD_ITEM WM_USER_MSG

#define LOG_DEST_OS2LOG  0
#define LOG_DEST_CORELOG 1

HWND logwin = 0, corelogwin = 0;
char abortload = 0;
char fast_exit = 0;
char game_is_running = 0;
char isfullscreen = 0;

extern struct vidmode_descrip *MAME_modes;

void genericerrorlog( char destination, const char *buffer )
{
  extern FILE *dbfp;

  char *bufcopy;

  bufcopy = (char *)malloc( strlen(buffer) + 1 );
  strcpy( bufcopy, buffer );

  switch ( destination )
  {
    case LOG_DEST_OS2LOG:
      fprintf( dbfp, "%s\n", buffer);
      fflush( dbfp );

      WinPostMsg( logwin, LOG_ADD_ITEM, MPFROMP(bufcopy), NULL );
    break;
    case LOG_DEST_CORELOG:
      WinPostMsg( corelogwin, LOG_ADD_ITEM, MPFROMP(bufcopy), NULL );
    break;
  }
}

void myerrorlog( const char *text, ... )
{
	va_list args;  
	char buffer[1024];

	va_start( args, text );
	vsprintf( (char *)buffer, text, args );
	va_end( args );

	// Strip off newline characters in case there are extras.
	while ( strlen( buffer ) && ( buffer[ strlen( buffer )-1 ] == 0xd || buffer[ strlen( buffer )-1 ] == 0xa) )
  {
		buffer[ strlen( buffer )-1 ] = 0;
	}

  genericerrorlog( LOG_DEST_OS2LOG, buffer );
}

void logerror( const char *text, ... )
{
	va_list args;  
	char buffer[1024];

  if ( !corelogwin ) return;

	va_start( args, text );
	vsprintf( (char *)buffer, text, args );
	va_end( args );

	// Strip off newline characters in case there are extras.
	while ( strlen( buffer ) && ( buffer[ strlen( buffer )-1 ] == 0xd || buffer[ strlen( buffer )-1 ] == 0xa) )
  {
		buffer[ strlen( buffer )-1 ] = 0;
	}

  genericerrorlog( LOG_DEST_CORELOG, buffer );
}

void CenterThisWindow( HWND win )
{
  RECTL rectl, rectl2;

  WinQueryWindowRect( HWND_DESKTOP, &rectl );
  WinQueryWindowRect( win, &rectl2 );
  WinSetWindowPos( win, 0,
    (rectl.xRight - (rectl2.xRight-rectl2.xLeft)-rectl.xLeft) / 2, 
    (rectl.yTop - (rectl2.yTop-rectl2.yBottom)-rectl.yBottom) / 2,
    0, 0, SWP_MOVE );
}

static MRESULT EXPENTRY (*OldListBoxProc)( HWND, ULONG, MPARAM, MPARAM) = NULL;

MRESULT EXPENTRY ListBoxWDblClick( HWND win, ULONG message,
 MPARAM mp1, MPARAM mp2)
{
  if ( message == WM_BUTTON1DBLCLK )
  {
    WinPostMsg( WinQueryWindow( win, QW_PARENT ), WM_COMMAND,
     MPFROMSHORT( DID_OK ), 0 );
	}
	return (*OldListBoxProc) (win, message, mp1, mp2 ); 
}

#define WM_SENSITIVECHECK WM_USER_MSG
// MP1 = window ID, MP2 = check state

static MRESULT EXPENTRY (*OldCheckBoxProc)( HWND, ULONG, MPARAM, MPARAM) = NULL;

MRESULT EXPENTRY SensitiveCheckBox( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  if ( msg == BM_SETCHECK )
  {
    WinPostMsg( WinQueryWindow( win, QW_PARENT ), WM_SENSITIVECHECK,
     MPFROMSHORT( WinQueryWindowUShort( win, QWS_ID ) ), mp1 );
  }
  return OldCheckBoxProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY BitmapScaler(HWND win, ULONG message, MPARAM mp1, MPARAM mp2)
{
  HBITMAP hbm;
  HPS hps;
  RECTL dest;

  switch (message) {
    case WM_CREATE:
    {
      USHORT *ctldata = (USHORT *)PVOIDFROMMP(mp1);
      hps = WinGetPS( win );
      hbm = GpiLoadBitmap( hps, NULLHANDLE, ctldata[0], 0, 0 );
      WinSetWindowULong( win, 0, hbm );
      WinReleasePS( hps );
    }
    break;
    case WM_PAINT:
      WinQueryWindowRect( win, &dest );
      hps = WinGetPS( win );
      hbm = WinQueryWindowULong( win, 0 );
      WinDrawBitmap( hps, hbm, NULL, (PPOINTL)&dest, 0, 0, DBM_NORMAL | DBM_STRETCH );
      WinReleasePS( hps );
    break;
    case WM_DESTROY:
      hbm = WinQueryWindowULong( win, 0 );
      GpiDeleteBitmap( hbm );
    break;
  }
  return WinDefWindowProc( win, message, mp1, mp2 );
}

MRESULT EXPENTRY LogWindowProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
      WinSendDlgItemMsg( win, LB_MAMELog, LM_INSERTITEM, MPFROMSHORT(LIT_END),
        MPFROMP( "*** Beginning of MAME Log ***" ) );
      WinSetWindowText( WinWindowFromID( win, FID_TITLEBAR ), PVOIDFROMMP(mp2) );
    break;
    case LOG_ADD_ITEM:
    {
      USHORT count;
      MRESULT mr;

      mr = WinSendDlgItemMsg( win, LB_MAMELog, LM_QUERYITEMCOUNT, NULL, NULL );
      count = SHORT1FROMMR(mr);

      if ( count >= 10000 )
      {
        WinSendDlgItemMsg( win, LB_MAMELog, LM_DELETEITEM, MPFROMSHORT(0), NULL );
        // Delete the oldest entry to keep the window from bogging down
        count--;
      }

      WinSendDlgItemMsg( win, LB_MAMELog, LM_INSERTITEM, MPFROMSHORT(LIT_END),
        mp1 );

      WinSendDlgItemMsg( win, LB_MAMELog, LM_SELECTITEM, MPFROMSHORT(count),
        MPFROMSHORT(TRUE) );

      free( PVOIDFROMMP(mp1) );
    }
    break;
    case WM_ADJUSTWINDOWPOS:
    {
      SWP *winpos;

      winpos = (SWP *)PVOIDFROMMP( mp1 );

      if ( winpos->fl & SWP_SIZE )
      {
        RECTL winrect;

        WinQueryWindowRect( win, &winrect );
        WinCalcFrameRect( win, &winrect, TRUE );
        // Get the client window size

        WinSetWindowPos( WinWindowFromID( win, LB_MAMELog ), 0,
         winrect.xLeft + 1, winrect.yBottom + 1,
         winrect.xRight - (2 * winrect.xLeft) - 2,
         winrect.yTop - (2 * winrect.yBottom) - 2,
         SWP_MOVE | SWP_SIZE );
        // Resize the listbox to the full client size
      }
    }
    break;
    case WM_CLOSE:
      if ( corelogwin == win )
      {
        WinDestroyWindow( win );
        corelogwin = 0;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

#define PBUL_HDC     0
#define PBUL_HPS     4
#define PBUL_BMP     8
#define PBUL_OLDMAX  12
#define PBUL_OLDVAL  16

MRESULT EXPENTRY PercentBarProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch( msg )
  {
    case WM_CREATE:
    {
      // Load up all bitmaps and put the handles in window ULONGs
      // Also set the current value and current animation frame to 0

      DEVOPENSTRUC dop = { 0, "DISPLAY", NULL, 0, 0, 0, 0, 0, 0 };
      BITMAPINFOHEADER2 bmpi = { 0 };
      SIZEL size = { 0, 0 };
      HDC hdc;
      HPS hps;
      SWP swp;
      RECTL rectl;
      HBITMAP bmp, pacbmps[8];
      int i, sequence;

      hdc = DevOpenDC( WinQueryAnchorBlock( win ), OD_MEMORY, "*", 5,
        (PDEVOPENDATA)&dop, NULLHANDLE );
      hps = GpiCreatePS( WinQueryAnchorBlock( win ), hdc, &size,
        PU_PELS | GPIT_MICRO | GPIA_ASSOC );

      WinQueryWindowPos( win, &swp );

      bmpi.cbFix = sizeof(BITMAPINFOHEADER2);
      bmpi.cx = swp.cx;
      bmpi.cy = swp.cy;
      bmpi.cPlanes = 1;
      bmpi.cBitCount = 8;
      bmpi.ulCompression = BCA_UNCOMP;
      bmp  = GpiCreateBitmap( hps, (PBITMAPINFOHEADER2)&bmpi, 0, 0, NULL );

      GpiSetBitmap( hps, bmp );

      WinSetWindowULong( win, PBUL_HDC, hdc );
      WinSetWindowULong( win, PBUL_HPS, hps );
      WinSetWindowULong( win, PBUL_BMP, bmp );

      for ( i = 0; i < 8; ++i )
      {
        pacbmps[i] = GpiLoadBitmap( hps, NULLHANDLE, 2 + i, 0, 0 );
      }

      GpiSetColor( hps, CLR_BLACK );
      GpiSetBackColor( hps, CLR_BLACK );

      sequence = 0;

      for ( i = 0; i < swp.cx; i += swp.cy )
      {
        rectl.xLeft = i;
        rectl.yBottom = 0;
        rectl.xRight = i + swp.cy;
        rectl.yTop = swp.cy;
        if ( rectl.xRight > swp.cx ) rectl.xRight = swp.cx;

        WinDrawBitmap( hps, pacbmps[sequence], NULL, (PPOINTL)&rectl, 0, 0,
          DBM_STRETCH );
        sequence = (sequence + 1) % 8;
      }

      for ( i = 0; i < 8; ++i )
      {
        GpiDeleteBitmap( pacbmps[i] );
      }

      WinSetWindowULong( win, PBUL_OLDMAX, 0 );
      WinSetWindowULong( win, PBUL_OLDVAL, 0 );
    }
    break;
    case WM_PAINT:
    {
      HPS hps, hps2;
      POINTL pts[4];
      RECTL rectl;

      int curval, totval, width;

      hps = WinBeginPaint( win, NULLHANDLE, NULL );
      hps2 = WinQueryWindowULong( win, PBUL_HPS );

      WinQueryWindowRect( win, &rectl );

      curval = WinQueryWindowULong( win, PBUL_OLDVAL );
      totval = WinQueryWindowULong( win, PBUL_OLDMAX );
      width = rectl.xRight - rectl.xLeft;

      if ( !totval ) totval = 1;

      pts[0].x = 0;  pts[0].y = 0;
      pts[1].x = (width * curval) / totval;
      pts[1].y = rectl.yTop - rectl.yBottom;
      pts[2].x = 0;  pts[2].y = 0;
      
      GpiBitBlt( hps, hps2, 3, pts, ROP_SRCCOPY, BBO_IGNORE );

      pts[0].x = (width * curval) / totval;
      pts[0].y = 0;
      pts[1].x = width;
      pts[1].y = rectl.yTop - rectl.yBottom;

      GpiMove(hps, &pts[0] );
      GpiBox(hps, DRO_OUTLINEFILL, &(pts[1]), 0, 0);

			WinEndPaint( hps );
    }
    break;
    case WM_CLOSE:
    {
      HPS hps;

      hps = WinQueryWindowULong( win, PBUL_HPS );
			GpiSetBitmap( hps, 0 );
			GpiDeleteBitmap( WinQueryWindowULong( win, PBUL_BMP ) );

      GpiDestroyPS( hps );
      DevCloseDC( WinQueryWindowULong( win, PBUL_HDC ) );
    }
    break;
    case WM_SETPBVALS:
    {
      WinSetWindowULong( win, PBUL_OLDVAL, SHORT1FROMMP(mp1) );
      WinSetWindowULong( win, PBUL_OLDMAX, SHORT2FROMMP(mp1) );

      WinInvalidateRect( win, NULL, TRUE );
    }
    break;
  }
  return WinDefWindowProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY ProgressWindowProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
    break;
    case WM_LOADPROGRESS:
    {
      USHORT curval, totval;

      if ( mp1 )
      {
        WinSetDlgItemText( win, ST_ItemLoading, mp1 );
        free( mp1 );
        MGLSC_mouseGrab( 0 );
        // don't grab mouse while ROM is loading
      } else {
        WinDismissDlg( win, 0 );
        WinSetFocus( HWND_DESKTOP, MGLSC_clientState()->clientwin );
        if ( globaloptions.enablemouse && globaloptions.mousegrab )
          MGLSC_mouseGrab( 1 );
        break;
      }

      curval = SHORT1FROMMP( mp2 );
      totval = SHORT2FROMMP( mp2 );

      WinPostMsg( WinWindowFromID( win, PB_PercentBar ), WM_SETPBVALS, mp2, NULL );
    }
    break;
    case WM_COMMAND:
      switch ( LONGFROMMP(mp1) )
      {
        case DID_CANCEL:
          MGLSC_mouseGrab( 0 );
          abortload = 1;
        break;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

#define SFUL_HDC           0
#define SFUL_HPS           4
#define SFUL_BMP           8
#define SFUL_STARBMP       12
#define SFUL_MAMEBMP       16
#define SFUL_MAMEBMPBOT    20
#define SFUL_NUMSTARS      24
#define SFUL_STARSIZEX     28
#define SFUL_STARSIZEY     30
#define SFUL_TEXTSCROLL    32
#define SFUL_CREDITBLOCK   36
#define SFUL_HRGN          40
#define SFUL_STARPOSARRAY  44  // each entry is 4 bytes, 100 entries max
#define SFUL_STARSIZEARRAY 444 // size 0 = small -> size 7 = full size
                               // each entry is one byte
#define SFUL_EXTRASIZE     546
// pad the end of the size array out to a USHORT boundary

#define SF_getStarPos( starnum, x, y ) \
{ \
  x = (signed short)WinQueryWindowUShort( win, SFUL_STARPOSARRAY + ((starnum) * 4) ); \
  y = (signed short)WinQueryWindowUShort( win, SFUL_STARPOSARRAY + ((starnum) * 4) + 2 ); \
}

#define SF_setStarPos( starnum, x, y ) \
{ \
  WinSetWindowUShort( win, SFUL_STARPOSARRAY + ((starnum) * 4),     (USHORT)x ); \
  WinSetWindowUShort( win, SFUL_STARPOSARRAY + ((starnum) * 4) + 2, (USHORT)y ); \
}

#define SF_getStarSize( starnum, starsize ) \
{ \
  starsize = WinQueryWindowUShort( win, SFUL_STARSIZEARRAY + (starnum) ) & 7; \
}

#define SF_setStarSize( starnum, starsize ) \
{ \
  USHORT tmpsize = WinQueryWindowUShort( win, SFUL_STARSIZEARRAY + (starnum) ); \
  tmpsize &= 0xff00; \
  tmpsize |= (starsize); \
  WinSetWindowUShort( win, SFUL_STARSIZEARRAY + (starnum), tmpsize ); \
}

struct creditblock
{
  int numlines;
  char **strings;
};

static char *strings1[] =
{
  "Version .37 beta 14",
  "Ported By, Marty Amodeo",
  "http://emuos2.netlabs.org",
};

static char *strings2[] =
{
  "Thanks to Adrian Gschwend",
  "for hosting the EmuOS/2 page at Netlabs"
};

static char *strings3[] =
{
  "Thanks to the folks at Scitech:",
  "Michal N. and Steve W.",
  "for MGL development and testing",
};

static char *strings4[] =
{
  "Thanks to Peter Ratschitzky",
  "for his patience testing",
  "with the Matrox video drivers"
};

static char *strings5[] =
{
  "Thanks to Peter Kocsis",
  "for helping make the DualMode",
  "library Pascal-friendly",
  "and for his assistance debugging"
};

static char *strings6[] =
{
  "Thanks to the MAME development team",
  "for making such a great emulator!"
};

static char *strings7[] =
{
  "And thanks to users like you",
  "for your feedback, support, and patience"
};

static char *strings8[] =
{
  "Hope you enjoy this!",
  "Send feedback and bug reports to",
  "mamedev@stny.rr.com"
};

#define TOTAL_CREDITS 8

struct creditblock credits[] =
{
  { 3, (char **) strings1 },
  { 2, (char **) strings2 },
  { 3, (char **) strings3 },
  { 3, (char **) strings4 },
  { 4, (char **) strings5 },
  { 2, (char **) strings6 },
  { 2, (char **) strings7 },
  { 3, (char **) strings8 },
};

MRESULT EXPENTRY StarFieldProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_CREATE:
    {
      BITMAPINFOHEADER2 bmpi = { 0 };
			BITMAPINFOHEADER bmpinf = { 0 };
      SIZEL size = { 0, 0 };
      HDC hdc;
      HPS hps;
      SWP swp;
      HBITMAP bmp, starbmp, mamebmp;
      int i, j, numstars, x, y, starsize;
      ULONG currentmscount;
      POINTL pts[3];
      RECTL rectl;
      HRGN rgn;

      SIZEF sizef;
      FATTRS fat;
      ULONG ulx, uly;

      hps = WinGetPS( win );

      hdc = DevOpenDC( WinQueryAnchorBlock( win ), OD_MEMORY, "*", 0,
        NULL, GpiQueryDevice( hps ) );

      WinReleasePS( hps );

      if ( !hdc ) myerrorlog( "Error opening device context 1." );

      hps = GpiCreatePS( WinQueryAnchorBlock( win ), hdc, &size,
        PU_PELS | GPIT_NORMAL | GPIA_ASSOC );

      if ( !hps ) myerrorlog( "Error opening presentation space 1." );

      // hdc and hps are the backbuffer used for blitting to the screen

      GpiCreateLogColorTable( hps, LCOL_RESET, LCOLF_RGB, 0, 0, NULL );

      WinQueryWindowPos( win, &swp );

      bmpi.cbFix = sizeof(BITMAPINFOHEADER2);
      bmpi.cx = swp.cx;
      bmpi.cy = swp.cy;
      bmpi.cPlanes = 1;
      bmpi.cBitCount = 16;
      bmpi.ulCompression = BCA_UNCOMP;
      bmp  = GpiCreateBitmap( hps, (PBITMAPINFOHEADER2)&bmpi, 0, 0, NULL );
      GpiSetBitmap( hps, bmp );

      if ( !bmp ) myerrorlog( "Error creating bitmap 1." );

      // Create a backbuffer bitmap and set it into the presentation space

      WinSetWindowULong( win, SFUL_HDC, hdc );
      WinSetWindowULong( win, SFUL_HPS, hps );
      WinSetWindowULong( win, SFUL_BMP, bmp );

      starbmp = GpiLoadBitmap( hps, NULLHANDLE, 10, 0, 0 );
			bmpinf.cbFix = sizeof( BITMAPINFOHEADER );
			GpiQueryBitmapParameters( starbmp, &bmpinf );

      // Load the star bitmap into hps and get some info about it

      WinSetWindowULong( win, SFUL_STARBMP, starbmp );

      mamebmp = GpiLoadBitmap( hps, NULLHANDLE, 1, 0, 0 );
      WinSetWindowULong( win, SFUL_MAMEBMP, mamebmp );

      DosQuerySysInfo( QSV_MS_COUNT, QSV_MS_COUNT, &currentmscount, 4 );
      srand( currentmscount );
      numstars = (rand() % 40) + 10;
      // between 10 and 50 stars to start

      WinSetWindowUShort( win, SFUL_NUMSTARS, numstars );
      WinSetWindowUShort( win, SFUL_STARSIZEX, bmpinf.cx );
      WinSetWindowUShort( win, SFUL_STARSIZEY, bmpinf.cy );

      GpiSetBackColor( hps, 0 );
      GpiSetBackMix( hps, BM_SRCTRANSPARENT );

      for ( i=0; i<numstars; ++i )
      {
        x = rand() % swp.cx;
        y = rand() % swp.cy;
        starsize = rand() % 8;

        SF_setStarPos( i, x, y );
        SF_setStarSize( i, starsize );
      }

      for ( j=0; j<8; ++j )
      {
        for ( i=0; i<numstars; ++i )
        {
          SF_getStarPos( i, x, y );
          SF_getStarSize( i, starsize );
          if ( starsize == j )
          {
            rectl.xLeft = x;
            rectl.yBottom = y;
            rectl.xRight = x + ((bmpinf.cx * (starsize+1)) / 8);
            rectl.yTop = y + ((bmpinf.cy * (starsize+1)) / 8);
            
            WinDrawBitmap( hps, starbmp, NULL, (PPOINTL)&rectl, 0, 0, DBM_STRETCH );
          }
        }
      }

      bmpinf.cbFix = sizeof( BITMAPINFOHEADER );
			GpiQueryBitmapParameters( mamebmp, &bmpinf );

      pts[0].x = (swp.cx - bmpinf.cx) / 2;
      pts[0].y = swp.cy - bmpinf.cy;
      WinDrawBitmap( hps, mamebmp, NULL, &(pts[0]), 0, 0, DBM_NORMAL );
      // Draw MAME logo in top center

      WinSetWindowULong( win, SFUL_MAMEBMPBOT, pts[0].y );

      fat.usRecordLength = sizeof( FATTRS );
      fat.fsSelection = 0;
      fat.lMatch = 0;
      strcpy( fat.szFacename, "Times New Roman Bold Italic" );
      fat.idRegistry = 0;
      fat.usCodePage = 0; // default code page
      fat.lMaxBaselineExt = 0;
      fat.lAveCharWidth = 0;
      fat.fsType = 0;
      fat.fsFontUse = FATTR_FONTUSE_OUTLINE;
      GpiCreateLogFont( hps, NULL, 1, &fat );

      fat.usRecordLength = sizeof( FATTRS );
      fat.fsSelection = 0;
      fat.lMatch = 0;
      strcpy( fat.szFacename, "Helvetica Bold" );
      fat.idRegistry = 0;
      fat.usCodePage = 0; // default code page
      fat.lMaxBaselineExt = 0;
      fat.lAveCharWidth = 0;
      fat.fsType = 0;
      fat.fsFontUse = FATTR_FONTUSE_OUTLINE;
      GpiCreateLogFont( hps, NULL, 2, &fat );

      GpiSetCharSet( hps, 1 );  // Times New Roman Bold Italic

      DevQueryCaps( hdc, CAPS_HORIZONTAL_FONT_RES, 1, &ulx );
      DevQueryCaps( hdc, CAPS_VERTICAL_FONT_RES,   1, &uly );
      sizef.cx = (65536 * ulx * 24) / 72;
      sizef.cy = (65536 * uly * 24) / 72;
      GpiSetCharBox( hps, &sizef );
      // 24 point font

      GpiQueryTextBox( hps, 8, "for OS/2", 3, pts );

      rectl.xLeft = 0;
      rectl.xRight = swp.cx;
      rectl.yBottom = 0;
      rectl.yTop = WinQueryWindowULong( win, SFUL_MAMEBMPBOT ) - pts[2].y - (pts[2].y/2);

      rgn = GpiCreateRegion( hps, 1, &rectl );
      // This region will be used for clipping the scrolling text

      WinSetWindowULong( win, SFUL_HRGN, rgn );
      WinSetWindowULong( win, SFUL_TEXTSCROLL, 0 );
      WinSetWindowULong( win, SFUL_CREDITBLOCK, 0 );

      // DosSetPriority( PRTYS_THREAD, PRTYC_TIMECRITICAL, 0, 0 );
      // Give us a little priority boost so the animation is smooth

      WinStartTimer( WinQueryAnchorBlock( win ), win, 0, 30 );
    }
    break;
    case WM_TIMER:
    {
      USHORT starcx, starcy, starsize;
      int numstars, x, y, i, j, scrolltop, creditblock, scrollpos;
      SWP swp;
      POINTL pts[3];
      HPS hps;
      HBITMAP mamebmp, starbmp;
      RECTL rectl;
			BITMAPINFOHEADER bmpinf;
      HRGN rgnold;
      SIZEF sizef;
      ULONG ulx, uly;
      HDC hdc;

      WinQueryWindowPos( win, &swp );

      hdc = WinQueryWindowULong( win, SFUL_HDC );
      hps = WinQueryWindowULong( win, SFUL_HPS );

      starbmp = WinQueryWindowULong( win, SFUL_STARBMP );
      mamebmp = WinQueryWindowULong( win, SFUL_MAMEBMP );

      starcx = WinQueryWindowUShort( win, SFUL_STARSIZEX );
      starcy = WinQueryWindowUShort( win, SFUL_STARSIZEY );
      numstars = WinQueryWindowULong( win, SFUL_NUMSTARS );

      pts[0].x = 0; pts[0].y = 0;
      GpiMove( hps, &(pts[0]) );
      pts[0].x = swp.cx; pts[0].y = swp.cy;
      GpiSetColor( hps, 0 );
      GpiBox( hps, DRO_FILL, &(pts[0]), 0, 0 );

      GpiSetBackMix( hps, BM_SRCTRANSPARENT );

      for ( j=0; j<8; ++j )
      {
        for ( i=0; i<numstars; ++i )
        {
          SF_getStarPos( i, x, y );
          SF_getStarSize( i, starsize );
          if ( starsize == j )
          {
            x -= (int)((((starsize + 1) * starcx) / 2) / 8);
            // Move it half the star's width for the largest size

            if ( x <= -1 * starcx )
            {
              x = swp.cx;
              y = rand() % swp.cy;
              starsize = rand() % 8;
              SF_setStarSize( i, starsize );
            }

            SF_setStarPos( i, x, y );

            rectl.xLeft = x;
            rectl.yBottom = y;
            rectl.xRight = x + ((starcx * (starsize+1)) / 8);
            rectl.yTop = y + ((starcy * (starsize+1)) / 8);
            
            WinDrawBitmap( hps, starbmp, NULL, (PPOINTL)&rectl, 0, 0, DBM_STRETCH );
          }
        }
      }

      bmpinf.cbFix = sizeof( BITMAPINFOHEADER );
			GpiQueryBitmapParameters( mamebmp, &bmpinf );

      pts[0].x = (swp.cx - bmpinf.cx) / 2;
      pts[0].y = swp.cy - bmpinf.cy;
      WinDrawBitmap( hps, mamebmp, NULL, &(pts[0]), 0, 0, DBM_NORMAL );
      // Draw MAME logo in top center

      DevQueryCaps( hdc, CAPS_HORIZONTAL_FONT_RES, 1, &ulx );
      DevQueryCaps( hdc, CAPS_VERTICAL_FONT_RES,   1, &uly );
      sizef.cx = (65536 * ulx * 24) / 72;
      sizef.cy = (65536 * uly * 24) / 72;
      GpiSetCharBox( hps, &sizef );
      // 24 point font

      GpiSetCharSet( hps, 1 );  // Times New Roman Bold Italic
      GpiQueryTextBox( hps, 8, "for OS/2", 3, pts );

      GpiSetBackMix( hps, BM_LEAVEALONE );
      GpiSetColor( hps, 0xff );
      pts[0].x = (swp.cx - pts[2].x) / 2;
      pts[0].y = WinQueryWindowULong( win, SFUL_MAMEBMPBOT ) - pts[2].y;
      GpiCharStringAt( hps, &(pts[0]), 8, "for OS/2" );

      GpiSetCharSet( hps, 2 );  // Helvetica Bold
      GpiSetClipRegion( hps, WinQueryWindowULong( win, SFUL_HRGN ), &rgnold );

      DevQueryCaps( hdc, CAPS_HORIZONTAL_FONT_RES, 1, &ulx );
      DevQueryCaps( hdc, CAPS_VERTICAL_FONT_RES,   1, &uly );
      sizef.cx = (65536 * ulx * 14) / 72;
      sizef.cy = (65536 * uly * 14) / 72;
      GpiSetCharBox( hps, &sizef );
      // 14 point font

      scrolltop = pts[0].y;

      creditblock = WinQueryWindowULong( win, SFUL_CREDITBLOCK );
      scrollpos = WinQueryWindowULong( win, SFUL_TEXTSCROLL );

      GpiSetColor( hps, 0x8000a0 );

      for ( i=0; i < credits[ creditblock ].numlines; ++i )
      {
        GpiQueryTextBox( hps, strlen( credits[creditblock].strings[i] ),
          credits[creditblock].strings[i], 3, pts );

        if ( i == 0 )
        {
          scrollpos -= pts[2].y;
        }
        // Negative-bias the first line with the Y size of the first line

        pts[0].x = (swp.cx - pts[2].x) / 2;  // Center each line
        pts[0].y = scrollpos;
        scrollpos -= pts[2].y + (pts[2].y / 2); // 1.5 line spacing
        GpiCharStringAt( hps, &(pts[0]),
          strlen( credits[creditblock].strings[i] ),
          credits[creditblock].strings[i] );
      }

      if ( scrollpos > scrolltop )
      {
        // The bottom line scrolled out of view

        creditblock = (creditblock + 1) % TOTAL_CREDITS;

        WinSetWindowULong( win, SFUL_TEXTSCROLL, 0 );
        WinSetWindowULong( win, SFUL_CREDITBLOCK, creditblock );
      } else {
        WinSetWindowULong( win, SFUL_TEXTSCROLL,
          WinQueryWindowULong( win, SFUL_TEXTSCROLL ) + 2 );
        // Advance the scroll 4 pixels
      }

      GpiSetClipRegion( hps, NULLHANDLE, &rgnold );

      WinInvalidateRect( win, NULL, TRUE );
    }
    // Intentional fall-through to WM_PAINT
    case WM_PAINT:
    {
      POINTL pts[3];
      RECTL rectl = {0};
      HPS hps, hps2;

      hps = WinBeginPaint( win, NULLHANDLE, &rectl );
      hps2 = WinQueryWindowULong( win, SFUL_HPS );

      pts[0].x = rectl.xLeft; pts[0].y = rectl.yBottom;
      pts[1].x = rectl.xRight;  pts[1].y = rectl.yTop;
      pts[2].x = rectl.xLeft; pts[2].y = rectl.yBottom;

			GpiBitBlt( hps, hps2, 3, pts, ROP_SRCCOPY, BBO_IGNORE );

			WinEndPaint( hps );
    }
    break;
    case WM_CLOSE:
    {
      HDC hdc;
      HPS hps;
      HBITMAP bmp, starbmp, mamebmp;
      HRGN rgn, rgnold;

      // Free up all this junk

      WinStopTimer( WinQueryAnchorBlock( win ), win, 0 );

      hdc = WinQueryWindowULong( win, SFUL_HDC );
      hps = WinQueryWindowULong( win, SFUL_HPS );
      bmp = WinQueryWindowULong( win, SFUL_BMP );
      starbmp = WinQueryWindowULong( win, SFUL_STARBMP );
      mamebmp = WinQueryWindowULong( win, SFUL_MAMEBMP );
      rgn = WinQueryWindowULong( win, SFUL_HRGN );

      GpiSetCharSet( hps, LCID_DEFAULT );
      GpiDeleteSetId( hps, 1 );
      GpiDeleteSetId( hps, 2 );

      GpiSetClipRegion( hps, NULLHANDLE, &rgnold );
      GpiDestroyRegion( hps, rgn );

      GpiSetBitmap( hps, NULLHANDLE );
      
      GpiDeleteBitmap( bmp );
      GpiDeleteBitmap( starbmp );
      GpiDeleteBitmap( mamebmp );

      GpiDestroyPS( hps );

      DevCloseDC( hdc );
    }
    break;
  }

  return WinDefWindowProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY WindowProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  extern int game_to_run;
  static HWND progresswin = 0;

  switch ( msg )
  {
    case WM_STARTGAME:
    {
      char *tmpstr;
      HSWITCH hs;
      SWCNTRL sc = {0};
      
      OpenProfile();
      LoadRapidKeysForGame( game_to_run );
      LoadInputOptionsFromProfile( game_to_run );
      CloseProfile();

      progresswin = WinLoadDlg( HWND_DESKTOP, HWND_DESKTOP,
        ProgressWindowProc, 0, ProgressWindow, NULL );
      
      tmpstr = malloc( strlen( drivers[game_to_run]->description ) + 16 );
      sprintf( tmpstr, "MAME for OS/2 - %s", drivers[game_to_run]->description );
      WinSetWindowText( WinWindowFromID( MGLSC_clientState()->framewin,
       FID_TITLEBAR ), tmpstr );

      hs = WinQuerySwitchHandle( MGLSC_clientState()->framewin, 0 );
      strncpy( sc.szSwtitle, tmpstr, 60 );
      WinChangeSwitchEntry( hs, &sc );

      free( tmpstr );
    }
    break;
    case WM_LOADPROGRESS:
      WinPostMsg( progresswin, WM_LOADPROGRESS, mp1, mp2 );
    break;
    case WM_ENDGAME:
    {
      HSWITCH hs;
      SWCNTRL sc = {0};

      game_is_running = 0;

      WinSetWindowText( WinWindowFromID( MGLSC_clientState()->framewin,
       FID_TITLEBAR ), "MAME for OS/2" );

      hs = WinQuerySwitchHandle( MGLSC_clientState()->framewin, 0 );
      strncpy( sc.szSwtitle, "MAME for OS/2", 60 );
      WinChangeSwitchEntry( hs, &sc );

      OpenProfile();
      LoadRapidKeysForGame( -1 );
      LoadInputOptionsFromProfile( -1 );
      CloseProfile();

      WinEnableMenuItem( WinWindowFromID( MGLSC_clientState()->framewin,
       FID_MENU ), FileQuickList, TRUE );
      WinEnableMenuItem( WinWindowFromID( MGLSC_clientState()->framewin,
       FID_MENU ), SettingsAudio, TRUE );

      if ( MGLSC_clientState()->isFullScreen )
      {
        WinPostMsg( win, WM_TOGGLEFS, 0, 0 );
      }
    }
    break;
    case WM_GAMEERROR:
      WinMessageBox( HWND_DESKTOP, win,
        "This game failed to start up.  For more details, open up the MAME core log and try to run it again.  The most likely explanation is that your ROM set was incomplete or incorrect.",
        "Game could not start up.  Sorry!", 0,
        MB_CANCEL | MB_ICONEXCLAMATION | MB_APPLMODAL | MB_MOVEABLE );
    break;
    case WM_CLOSE:
    {
      extern char keymap[];
      extern int game_to_run;
      extern HEV run_game_sem;

      if ( logwin )
      {
        WinDismissDlg( logwin, 0 );
        WinDestroyWindow( logwin );
        logwin = 0;
      }

      if ( corelogwin )
      {
        WinDismissDlg( corelogwin, 0 );
        WinDestroyWindow( corelogwin );
        corelogwin = 0;
      }

      if ( progresswin )
      {
        WinDestroyWindow( progresswin );
        progresswin = 0;
      }

      keymap[KB_esc] = 1;

      if ( !fast_exit )
      {
        fast_exit = 1;
        return 0;
      }

      MGLSC_mouseGrab(0);
      game_to_run = -1;
      DosPostEventSem( run_game_sem );
    }
    break;
    case WM_FOCUSCHANGE:
    {
      extern char frame_advance_mode;
      extern HEV frame_advance_sem;
      extern int status_paused;

      if ( !game_is_running )
      {
        break;
      }

      if ( !globaloptions.autopause )
      {
        // User specified not to pause on focus change.

        break;
      }

      if ( isfullscreen )
      {
        // Don't care about focus changing if we're kicking full screen

        break;
      }

      if ( SHORT1FROMMP( mp2 ) == FALSE )
      {
        // Losing the focus

        if ( status_paused ) break;
        // if we're already paused, no need to do this stuff

        frame_advance_mode = 1;
        osd_pause(2);
      } else {
        // Regaining the focus

        if ( status_paused < 2 ) break;
        // Only do the following if we paused from a focus change

        frame_advance_mode = 0;
        osd_pause(0);
        DosPostEventSem( frame_advance_sem );
      }
    }
    break;
    case WM_KEYLEDS:
    {
      extern void writeKeyboardLEDs( char, char, char );

      writeKeyboardLEDs( SHORT1FROMMP(mp1), SHORT2FROMMP(mp1),
       SHORT1FROMMP(mp2) );
    }
    break;
  }
  return WinDefWindowProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY SplashScreenProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
      WinStartTimer( WinQueryAnchorBlock( win ), win, 0, 20000 );
    break;
    case WM_TIMER:
      WinStopTimer( WinQueryAnchorBlock( win ), win, 0 );
      WinPostMsg( win, WM_COMMAND, MPFROMSHORT( DID_CANCEL ), 0 );
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}


static MRESULT EXPENTRY (*OldFrameWinProc)( HWND, ULONG, MPARAM, MPARAM)
 = NULL;

MRESULT EXPENTRY FrameWinKeyBypass( HWND win, ULONG msg, MPARAM mp1,
 MPARAM mp2 )
{
  if ( game_is_running && globaloptions.altbypass )
  {
    if ( msg == WM_CHAR || msg == WM_TRANSLATEACCEL )
    {
      return 0;
    }
  }
	return (*OldFrameWinProc) (win, msg, mp1, mp2 ); 
}

void WindowInit( HWND win )
{
  logwin = WinLoadDlg( HWND_DESKTOP, HWND_DESKTOP, LogWindowProc,
    0, LogWindow, "MAME OS/2 Log" );

  WinRegisterClass( WinQueryAnchorBlock( win ),
    "MAME Percent Bar", PercentBarProc, 0, 20 );
  WinRegisterClass( WinQueryAnchorBlock( win ),
    "MAME StarField", StarFieldProc, CS_SYNCPAINT, SFUL_EXTRASIZE );
  WinRegisterClass( WinQueryAnchorBlock( win ),
    "Bitmap Scaler", BitmapScaler, 0, 4 );

  OldFrameWinProc = WinSubclassWindow( MGLSC_clientState()->framewin,
   FrameWinKeyBypass );

  OpenProfile();
  LoadMiscOptionsFromProfile();

  WinCheckMenuItem( WinWindowFromID( MGLSC_clientState()->framewin, FID_MENU ),
   SettingsAutoPause, globaloptions.autopause );
  WinCheckMenuItem( WinWindowFromID( MGLSC_clientState()->framewin, FID_MENU ),
   SettingsSimLED, globaloptions.simled );

  if ( !WasSplashScreenShown() )
  {
    CloseProfile();

    WinDlgBox( HWND_DESKTOP, MGLSC_clientState()->framewin, SplashScreenProc,
     0, InMemoryOf, NULL );

    OpenProfile();
    SplashScreenWasShown();
  }
  CloseProfile();
}

MRESULT EXPENTRY ChangePathsProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  static int modifying = 0;

  switch ( msg )
  {
    case WM_INITDLG:
    {
      MRESULT mr;

      CenterThisWindow( win );

      mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_INSERTITEM,
        MPFROMSHORT( LIT_END ), MPFROMP( "Game ROMs" ) );
      WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
        MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMP( globaloptions.rompath ) );

      mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_INSERTITEM,
        MPFROMSHORT( LIT_END ), MPFROMP( "Audio samples" ) );
      WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
        MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMP( globaloptions.samplepath ) );

      mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_INSERTITEM,
        MPFROMSHORT( LIT_END ), MPFROMP( "Background artwork" ) );
      WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
        MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMP( globaloptions.artpath ) );

      mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_INSERTITEM,
        MPFROMSHORT( LIT_END ), MPFROMP( "Saved states" ) );
      WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
        MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMP( globaloptions.statepath ) );

      mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_INSERTITEM,
        MPFROMSHORT( LIT_END ), MPFROMP( "Screen captures" ) );
      WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
        MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMP( globaloptions.capturepath ) );

      WinSendDlgItemMsg( win, CB_SearchFor, LM_SELECTITEM,
        MPFROMSHORT( 0 ), MPFROMLONG( TRUE ) );
    }
    break;
    case WM_CONTROL:
      switch ( SHORT1FROMMP(mp1) )
      {
        case CB_SearchFor:
          switch ( SHORT2FROMMP(mp1) )
          {
            case LN_SELECT:
            {
              MRESULT mr;
              struct MAMEpaths *selection;
              int i;

              // An item was selected from the "SearchFor" combo box
              // Update list box with the directory names in the path
              // Select the first entry in the list box to populate the entry field

              mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYSELECTION,
                MPFROMSHORT( LIT_FIRST ), NULL );
              mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
                MPFROMSHORT( SHORT1FROMMR(mr) ), NULL );

              selection = (struct MAMEpaths *) PVOIDFROMMR(mr);

              WinSendDlgItemMsg( win, LB_SearchDirs, LM_DELETEALL,
                NULL, NULL );

              for ( i=0; i<selection->numpaths; ++i )
              {
                WinSendDlgItemMsg( win, LB_SearchDirs, LM_INSERTITEM,
                  MPFROMSHORT( LIT_END ), MPFROMP( selection->paths[i] ) );
              }

              WinSendDlgItemMsg( win, LB_SearchDirs, LM_SELECTITEM,
                MPFROMSHORT( 0 ), MPFROMLONG( TRUE ) );
            }
            break; // Item selected
          }
        break; // Combo box CB_SearchFor
        case LB_SearchDirs:
          switch ( SHORT2FROMMP(mp1) )
          {
            case LN_SELECT:
            {
              MRESULT mr;
              char *tmppath;
              int stringlength;
              SHORT idx;

              // An item was selected in the "SearchDirs" list box
              // Update the text entry field with the selected item

              mr = WinSendDlgItemMsg( win, LB_SearchDirs, LM_QUERYSELECTION,
                MPFROMSHORT( LIT_FIRST ), NULL );
              idx = (SHORT) SHORT1FROMMR(mr);
              mr = WinSendDlgItemMsg( win, LB_SearchDirs, LM_QUERYITEMTEXTLENGTH,
                MPFROMSHORT(idx), NULL );
              stringlength = LONGFROMMR( mr ) + 1;
              tmppath = malloc( stringlength );
              WinSendDlgItemMsg( win, LB_SearchDirs, LM_QUERYITEMTEXT,
                MPFROM2SHORT( idx, stringlength ), MPFROMP( tmppath ) );
              WinSetDlgItemText( win, EF_SelectedDir, tmppath );
              free( tmppath );
            }
            break; // Item selected
          }
        break; // List box LB_SearchDirs
      }
    break; // WM_CONTROL
    case WM_COMMAND:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case B_AddDir:
        {
          MRESULT mr;
          struct MAMEpaths *selection, *newpath;
          int i;
          SHORT idx;

          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), NULL );
          idx = SHORT1FROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( idx ), NULL );

          selection = (struct MAMEpaths *) PVOIDFROMMR(mr);

          newpath = (struct MAMEpaths *) malloc( sizeof(struct MAMEpaths) );
          newpath->numpaths = selection->numpaths + 1;
          newpath->isdefault = 0;
          newpath->paths = (char **) malloc( sizeof( char * ) * newpath->numpaths );

          for ( i=0; i<selection->numpaths; ++i )
          {
            newpath->paths[i] = (char *) malloc( strlen( selection->paths[i] ) + 1 );
            strcpy( newpath->paths[i], selection->paths[i] );
          }

          i = WinQueryDlgItemTextLength( win, EF_SelectedDir ) + 1;
          newpath->paths[ (int)selection->numpaths ] = (char *) malloc( i );
          WinQueryDlgItemText( win, EF_SelectedDir, i,
            newpath->paths[ (int)selection->numpaths ] );

          // The current entry has been cloned with the additional path entry added

          WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
            MPFROMSHORT( idx ), MPFROMP( newpath ) );

          if ( !selection->isdefault )
          {
            // Deconstruct the previous non-static path structure

            for ( i=0; i<selection->numpaths; ++i )
            {
              free( selection->paths[i] );
            }
            free( selection->paths );
            free( selection );
          }

          WinSendMsg( win, WM_CONTROL, MPFROM2SHORT( CB_SearchFor, LN_SELECT ), 0 );
          // Updates the SearchDirs list box

          return 0;
        }
        break;
        case B_RemoveDir:
        {
          MRESULT mr;
          struct MAMEpaths *selection, *newpath;
          int i, j;
          SHORT idx, selidx;

          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), NULL );
          idx = SHORT1FROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( idx ), NULL );

          selection = (struct MAMEpaths *) PVOIDFROMMR(mr);

          if ( !selection->numpaths )
          {
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }

          newpath = (struct MAMEpaths *) malloc( sizeof(struct MAMEpaths) );
          newpath->numpaths = selection->numpaths - 1;
          newpath->isdefault = 0;
          newpath->paths = (char **) malloc( sizeof( char * ) * newpath->numpaths );

          mr = WinSendDlgItemMsg( win, LB_SearchDirs, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), NULL );
          selidx = SHORT1FROMMR( mr );

          for ( i=0, j=0; i<selection->numpaths; ++i )
          {
            if ( i == selidx ) continue;

            newpath->paths[j] = (char *) malloc( strlen( selection->paths[i] ) + 1 );
            strcpy( newpath->paths[j], selection->paths[i] );

            ++j;
          }

          // Copy everything over except the one we're deleting

          WinSendDlgItemMsg( win, CB_SearchFor, LM_SETITEMHANDLE,
            MPFROMSHORT( idx ), MPFROMP( newpath ) );

          if ( !selection->isdefault )
          {
            // Deconstruct the previous non-static path structure

            for ( i=0; i<selection->numpaths; ++i )
            {
              free( selection->paths[i] );
            }
            free( selection->paths );
            free( selection );
          }

          if ( !modifying )
          {
            WinSendMsg( win, WM_CONTROL, MPFROM2SHORT( CB_SearchFor, LN_SELECT ), 0 );
            // Updates the SearchDirs list box
          }

          return 0;
        }
        break;
        case B_ModifyDir:
          modifying = 1;
          WinSendMsg( win, WM_COMMAND, MPFROMSHORT( B_RemoveDir ), 0 );
          WinSendMsg( win, WM_COMMAND, MPFROMSHORT( B_AddDir ), 0 );
          modifying = 0;
          return 0;
        break;
        case DID_OK:
        {
          MRESULT mr;

          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( 0 ), 0 );
          globaloptions.rompath = (struct MAMEpaths *) PVOIDFROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( 1 ), 0 );
          globaloptions.samplepath = (struct MAMEpaths *) PVOIDFROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( 2 ), 0 );
          globaloptions.artpath = (struct MAMEpaths *) PVOIDFROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( 3 ), 0 );
          globaloptions.statepath = (struct MAMEpaths *) PVOIDFROMMR(mr);
          mr = WinSendDlgItemMsg( win, CB_SearchFor, LM_QUERYITEMHANDLE,
            MPFROMSHORT( 4 ), 0 );
          globaloptions.capturepath = (struct MAMEpaths *) PVOIDFROMMR(mr);
          OpenProfile();
          SavePathsToProfile();
          CloseProfile();
        }
        break;
        case DID_CANCEL:
          OpenProfile();
          LoadPathsFromProfile();
          CloseProfile();
        break;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY AboutBoxProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

#define WM_ROMSETOK      WM_USER_MSG
#define WM_ROMSETCHECKED WM_USER_MSG + 1
#define WM_CHECKDONE     WM_USER_MSG + 2

#define WM_REINITDLG     WM_USER_MSG

static char stopverification = 0;

int GameIsRunnable( int game )
{
  const struct RomModule *romp;
  const struct GameDriver *drv;
  void *file;
  char crc[9];

  if ( !osd_faccess( drivers[game]->name, OSD_FILETYPE_ROM ) )
  {
    if ( drivers[game]->clone_of == 0 ||
         (drivers[game]->clone_of->flags & NOT_A_DRIVER) ||
         !osd_faccess(drivers[game]->clone_of->name, OSD_FILETYPE_ROM) )
    {
      return 0;
    }
  }

	for (romp = (drivers[game]->rom) + 1; romp; romp = rom_next_region(romp) )
	{
    while ( romp && !ROMENTRY_ISREGIONEND(romp) )
    {
      if ( ROMENTRY_ISFILE(romp) )
      {
        for ( drv = drivers[game], file = NULL; !file && drv;
              drv = drv->clone_of )
        {
          file = osd_fopen(drv->name, ROM_GETNAME(romp), OSD_FILETYPE_ROM, 0);
        }

        if ( !file )
        {
          sprintf( crc, "%08x", ROM_GETCRC(romp) );
          for ( drv = drivers[game], file = NULL; !file && drv;
                drv = drv->clone_of )
          {
            file = osd_fopen(drv->name, crc, OSD_FILETYPE_ROM, 0);
          }
        }

        if ( !file )
        {
          if ( !ROM_ISOPTIONAL(romp) )
          {
            myerrorlog( "ROM set %s rejected.  Can't open necessary file (%s).",
              drivers[game]->name, ROM_GETNAME(romp) );
            return 0;
          }
        } else osd_fclose( file );
      }
      romp++;
    }
  }

  return 1;
}

void VerifyAllROMs( void *arg )
{
  int i;
  HWND dlgwin = (HWND) arg;

  for ( i=0; drivers[i]; ++i )
  {
    if ( stopverification )
    {
      OpenProfile();
      LoadAvailableGamesFromProfile();
      CloseProfile();
      // Restore any flags we may have toggled if the user wanted us
      // to cancel the operation

      stopverification = 0;

      _endthread();
      return;
    }

    availabledrivers[i] &= ~DRIVER_FLAGS_AVAILABLE;

    if ( GameIsRunnable( i ) )
    {
      availabledrivers[i] |= DRIVER_FLAGS_AVAILABLE;
      WinPostMsg( dlgwin, WM_ROMSETOK, MPFROMLONG(i), 0 );
    } else {
      availabledrivers[i] &= ~DRIVER_FLAGS_FAVORITE;
    }

    WinPostMsg( dlgwin, WM_ROMSETCHECKED, 0, 0 );
  }
  
  OpenProfile();
  SaveAvailableGamesToProfile();
  SaveFavoriteGamesToProfile();
  CloseProfile();

  WinPostMsg( dlgwin, WM_CHECKDONE, 0, 0 );

  _endthread();
}

MRESULT EXPENTRY ROMScanProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  static int setschecked, setsok;
  static char numtext[10];

  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
      stopverification = 0;
      setschecked = 0;
      setsok = 0;
      _beginthread( VerifyAllROMs, NULL, 32768, (void *)win );
    break;
    case WM_COMMAND:
    case WM_CLOSE:
      stopverification = 1;
    break;
    case WM_ROMSETOK:
      setsok++;
      sprintf( numtext, "%d", setsok );
      WinSetDlgItemText( win, ST_ROMSetsVerified, numtext );
      WinSetDlgItemText( win, ST_ROMDescription,
        drivers[LONGFROMMP(mp1)]->description );
    break;
    case WM_ROMSETCHECKED:
      setschecked++;
      WinSendDlgItemMsg( win, PB_ScanPercentBar, WM_SETPBVALS,
        MPFROM2SHORT(setschecked, totaldrivers), 0 );
    break;
    case WM_CHECKDONE:
      WinPostMsg( WinQueryWindow( win, QW_OWNER ), WM_REINITDLG, 0, 0 );
      WinDefDlgProc( win, WM_COMMAND, MPFROMSHORT(DID_CANCEL), 0 );
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

void PopulateLists( HWND win )
{
  int i, driver;
  SHORT idx, idx2, cnt;
  MRESULT mr;

  cnt = 0;

  for ( i=0; i<totaldrivers; ++i )
  {
    if ( availabledrivers[i] & DRIVER_FLAGS_AVAILABLE )
    {
      mr = WinSendDlgItemMsg( win, LB_QuickList, LM_INSERTITEM, 
        MPFROMSHORT( LIT_SORTASCENDING ), MPFROMP( drivers[i]->description ) );
      idx = SHORT1FROMMR( mr );
      WinSendDlgItemMsg( win, LB_QuickList, LM_SETITEMHANDLE,
        MPFROMSHORT(idx), MPFROMLONG(i) );
      cnt++;
    }
  }

  for ( idx=0; idx<cnt; ++idx )
  {
    mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYITEMHANDLE,
      MPFROMSHORT(idx), 0 );
    driver = LONGFROMMR( mr );

    if ( availabledrivers[driver] & DRIVER_FLAGS_FAVORITE )
    {
      mr = WinSendDlgItemMsg( win, LB_Favorites, LM_INSERTITEM, 
        MPFROMSHORT( LIT_SORTASCENDING ),
        MPFROMP( drivers[driver]->description ) );
      idx2 = SHORT1FROMMR( mr );
      WinSendDlgItemMsg( win, LB_Favorites, LM_SETITEMHANDLE,
        MPFROMSHORT(idx2), MPFROMSHORT(idx) );
    }
  }
}

MRESULT EXPENTRY QuickListProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  static char favoriteschanged = 0;
  static char noautoselect = 0;

  switch ( msg )
  {
    case WM_INITDLG:
      OldListBoxProc = WinSubclassWindow( WinWindowFromID( win, LB_QuickList ),
        ListBoxWDblClick );

      WinSubclassWindow( WinWindowFromID( win, LB_Favorites ),
        ListBoxWDblClick );

      CenterThisWindow( win );
      OpenProfile();
      LoadAvailableGamesFromProfile();
      LoadFavoriteGamesFromProfile();
      CloseProfile();
      favoriteschanged = 0;
      noautoselect = 0;
      PopulateLists( win );
    break;
    case WM_REINITDLG:
      favoriteschanged = 0;
      WinSendDlgItemMsg( win, LB_QuickList, LM_DELETEALL, 0, 0 );
      WinSendDlgItemMsg( win, LB_Favorites, LM_DELETEALL, 0, 0 );
      PopulateLists( win );
    break;
    case WM_CONTROL:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case LB_Favorites:
          if ( SHORT2FROMMP( mp1 ) == LN_SELECT && !noautoselect )
          {
            MRESULT mr;
            SHORT idx;

            mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
              MPFROMSHORT( LIT_FIRST ), NULL );
            idx = SHORT1FROMMR( mr );
            mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYITEMHANDLE,
              MPFROMSHORT( idx ), 0 );
            idx = SHORT1FROMMR( mr );
            noautoselect = 1;
            WinSendDlgItemMsg( win, LB_QuickList, LM_SELECTITEM,
              MPFROMSHORT( idx ), MPFROMLONG( TRUE ) );
            noautoselect = 0;
          }
        break;
        case LB_QuickList:
          if ( SHORT2FROMMP( mp1 ) == LN_SELECT && !noautoselect )
          {
            MRESULT mr;
            SHORT idx, cnt, i;
            int driver;
            char found = 0;

            mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYSELECTION,
              MPFROMSHORT( LIT_FIRST ), NULL );
            idx = SHORT1FROMMR( mr );
            mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYITEMHANDLE,
              MPFROMSHORT( idx ), 0 );
            driver = LONGFROMMR( mr );
            if ( availabledrivers[driver] & DRIVER_FLAGS_FAVORITE )
            {
              // Search the favorites list for this entry and highlight it
              mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYITEMCOUNT,
                0, 0 );
              cnt = SHORT1FROMMR( mr );
              for ( i=0; i<cnt; ++i )
              {
                mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYITEMHANDLE,
                  MPFROMSHORT(i), 0 );
                if ( SHORT1FROMMR( mr ) == idx )
                {
                  noautoselect = 1;
                  WinSendDlgItemMsg( win, LB_Favorites, LM_SELECTITEM,
                    MPFROMSHORT( i ), MPFROMLONG( TRUE ) );
                  noautoselect = 0;
                  found = 1;
                  break;
                }
              }
              if ( !found )
              {
                mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
                  MPFROMSHORT( LIT_FIRST ), NULL );
                idx = (SHORT) SHORT1FROMMR( mr );
                if ( idx != LIT_NONE )
                {
                  noautoselect = 1;
                  WinSendDlgItemMsg( win, LB_Favorites, LM_SELECTITEM,
                    MPFROMSHORT( idx ), MPFROMLONG( FALSE ) );
                  noautoselect = 0;
                }
                // Deselect whatever was selected in the Favorites list if no match
              }
            } else {
              // New selection is not a favorite

              mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
                MPFROMSHORT( LIT_FIRST ), NULL );
              idx = (SHORT) SHORT1FROMMR( mr );
              if ( idx != LIT_NONE )
              {
                noautoselect = 1;
                WinSendDlgItemMsg( win, LB_Favorites, LM_SELECTITEM,
                  MPFROMSHORT( idx ), MPFROMLONG( FALSE ) );
                noautoselect = 0;
              }
              // Deselect whatever was selected in the Favorites list
            }
          }
        break;
      }
    break;
    case WM_COMMAND:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case B_ScanForROMs:
          WinDlgBox( HWND_DESKTOP, win, ROMScanProc, 0, ROMScanWindow, NULL );
          return 0;
        break;
        case B_AddToFavorites:
        {
          MRESULT mr;
          SHORT idx, idx2;
          int i;

          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx = (SHORT) SHORT1FROMMR( mr );
          if ( idx == LIT_NONE )
          {
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }
          mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          if ( (SHORT) SHORT1FROMMR( mr ) != LIT_NONE )
          {
            // already in favorites list
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }
          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYITEMHANDLE,
            MPFROMSHORT( idx ), 0 );
          i = LONGFROMMR( mr );
          mr = WinSendDlgItemMsg( win, LB_Favorites, LM_INSERTITEM,
            MPFROMSHORT( LIT_SORTASCENDING ), MPFROMP(drivers[i]->description) );
          idx2 = SHORT1FROMMR( mr );
          WinSendDlgItemMsg( win, LB_Favorites, LM_SETITEMHANDLE,
            MPFROMSHORT( idx2 ), MPFROMSHORT( idx ) );
          WinSendDlgItemMsg( win, LB_Favorites, LM_SELECTITEM,
            MPFROMSHORT( idx2 ), MPFROMLONG( TRUE ) );

          availabledrivers[i] |= DRIVER_FLAGS_FAVORITE;
          favoriteschanged = 1;
          return 0;
        }
        break;
        case B_RemoveFromFavorites:
        {
          MRESULT mr;
          SHORT idx, idx2;
          int i;

          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx = (SHORT) SHORT1FROMMR( mr );
          if ( idx == LIT_NONE )
          {
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }
          mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx2 = (SHORT) SHORT1FROMMR( mr );
          if ( idx2 == LIT_NONE )
          {
            // not in favorites list
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }
          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYITEMHANDLE,
            MPFROMSHORT( idx ), 0 );
          i = LONGFROMMR( mr );
          WinSendDlgItemMsg( win, LB_Favorites, LM_DELETEITEM,
            MPFROMSHORT( idx2 ), 0 );
          mr = WinSendDlgItemMsg( win, LB_Favorites, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx2 = (SHORT) SHORT1FROMMR( mr );
          if ( idx2 != LIT_NONE )
          {
            noautoselect = 1;
            WinSendDlgItemMsg( win, LB_Favorites, LM_SELECTITEM,
              MPFROMSHORT( idx2 ), MPFROMLONG( FALSE ) );
            noautoselect = 0;
          }

          availabledrivers[i] &= ~DRIVER_FLAGS_FAVORITE;
          favoriteschanged = 1;
          return 0;
        }
        break;
        case DID_OK:
        case B_RunGame:
        {
          MRESULT mr;
          SHORT idx;

          extern int game_to_run;
          extern HEV run_game_sem;
          // from os2.c

          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx = (SHORT) SHORT1FROMMR( mr );
          if ( idx == LIT_NONE )
          {
            WinAlarm( HWND_DESKTOP, WA_WARNING );
            return 0;
          }

          WinSendMsg( win, WM_COMMAND, MPFROMSHORT(DID_CANCEL), 0 );

          mr = WinSendDlgItemMsg( win, LB_QuickList, LM_QUERYITEMHANDLE,
            MPFROMSHORT( idx ), 0 );
          game_to_run = LONGFROMMR( mr );

          OpenProfile();
          if ( CheckIfGameIsDangerous( game_to_run ) )
          {
            ULONG resp;
            resp = WinMessageBox( HWND_DESKTOP, win,
              "This game may have caused MAME to exit unexpectedly the last time it was run.  Are you sure you want to run it again?",
              "Potentially Dangerous Game!", 0,
              MB_YESNO | MB_ICONEXCLAMATION | MB_APPLMODAL | MB_MOVEABLE );
            if ( resp != MBID_YES )
            {
              CloseProfile();
              return 0;
            }
          }
          MarkGamePotentiallyDangerous( game_to_run );
          CloseProfile();

          WinEnableMenuItem( WinWindowFromID( MGLSC_clientState()->framewin,
            FID_MENU ), FileQuickList, FALSE );
          WinEnableMenuItem( WinWindowFromID( MGLSC_clientState()->framewin,
            FID_MENU ), SettingsAudio, FALSE );

          game_is_running = 1;

          DosPostEventSem( run_game_sem );

          return 0;
        }
        break;
        case DID_CANCEL:
          if ( favoriteschanged )
          {
            favoriteschanged = 0;
            OpenProfile();
            SaveFavoriteGamesToProfile();
            CloseProfile();
          }
          // Allow WinDefDlgProc to get this WM_COMMAND and close the window
        break;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY FrameRateProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  extern void turnOffTimer0( void );
  extern void turnOnTimer0( void );

  switch ( msg )
  {
    case WM_INITDLG:
      CenterThisWindow( win );
      WinSendDlgItemMsg( win, SB_AutoSkipMax, SPBM_SETLIMITS,
       MPFROMLONG( 10 ), MPFROMLONG( 1 ) );
      WinSendDlgItemMsg( win, SB_ManualSkip, SPBM_SETLIMITS,
       MPFROMLONG( 10 ), MPFROMLONG( 0 ) );

      if ( globaloptions.autoskip )
      {
        WinCheckButton( win, RB_Dynamic, TRUE );
        WinSendDlgItemMsg( win, SB_AutoSkipMax, SPBM_SETCURRENTVALUE,
         MPFROMLONG( (LONG)globaloptions.autoskip ), 0 );
        WinSendDlgItemMsg( win, SB_ManualSkip, SPBM_SETCURRENTVALUE,
         MPFROMLONG( (LONG)globaloptions.mskip ), 0 );
        WinSendMsg( win, WM_CONTROL, MPFROM2SHORT( RB_Dynamic, BN_CLICKED ),
          0 );
      } else {
        WinCheckButton( win, RB_Static, TRUE );
        WinSendDlgItemMsg( win, SB_AutoSkipMax, SPBM_SETCURRENTVALUE,
         0, 0 );
        WinSendDlgItemMsg( win, SB_ManualSkip, SPBM_SETCURRENTVALUE,
         MPFROMLONG( (LONG)globaloptions.mskip ), 0 );
        WinSendMsg( win, WM_CONTROL, MPFROM2SHORT( RB_Static, BN_CLICKED ),
          0 );
      }
      WinCheckButton( win, CB_Timer0, globaloptions.usetimer0 );
    break;
    case WM_CONTROL:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case RB_Dynamic:
        case RB_Static:
          if ( SHORT2FROMMP( mp1 ) == BN_CLICKED )
          {
            USHORT isdynamic = WinQueryButtonCheckstate( win, RB_Dynamic );

            WinEnableWindow( WinWindowFromID( win, ST_DynaDesc1 ), isdynamic );
            WinEnableWindow( WinWindowFromID( win, ST_DynaDesc2 ), isdynamic );
            WinEnableWindow( WinWindowFromID( win, SB_AutoSkipMax ), isdynamic );

            WinEnableWindow( WinWindowFromID( win, ST_StaticDesc1 ), !isdynamic );
            WinEnableWindow( WinWindowFromID( win, ST_StaticDesc2 ), !isdynamic );
            WinEnableWindow( WinWindowFromID( win, SB_ManualSkip ), !isdynamic );
          }
        break;
      }
    break;
    case WM_COMMAND:
      if ( SHORT1FROMMP( mp1 ) == DID_OK )
      {
        ULONG value = 0;
        USHORT isdynamic = WinQueryButtonCheckstate( win, RB_Dynamic );

        if ( isdynamic )
        {
          WinSendDlgItemMsg( win, SB_AutoSkipMax, SPBM_QUERYVALUE,
           MPFROMP( &value ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          globaloptions.autoskip = value;
          globaloptions.mskip = 0;
          MGLSC_setMaxFrameSkip( value );
        } else {
          WinSendDlgItemMsg( win, SB_ManualSkip, SPBM_QUERYVALUE,
           MPFROMP( &value ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          globaloptions.mskip = value;
          globaloptions.autoskip = 0;
          MGLSC_setMaxFrameSkip( 0 );
        }
        globaloptions.usetimer0 = WinQueryButtonCheckstate( win, CB_Timer0 );
        MGLSC_setTimingMode( globaloptions.usetimer0 );
        OpenProfile();
        SaveFrameRateOptionsToProfile();
        CloseProfile();
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

#define AUDQUALSETTINGS 5

static char *audqualstrings[ AUDQUALSETTINGS ] =
{
  "8000 Hz",
  "11025 Hz",
  "22050 Hz",
  "33075 Hz",
  "44100 Hz"
};

static int audqualnums[ AUDQUALSETTINGS ] =
{
  8000, 11025, 22050, 33075, 44100
};

MRESULT EXPENTRY AudioProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
    {
      MRESULT mr;
      SHORT audqualnum;
      int i;

      OldCheckBoxProc = WinSubclassWindow(
       WinWindowFromID( win, CB_EnableAudio ), SensitiveCheckBox );

      CenterThisWindow( win );
      WinSendDlgItemMsg( win, SB_BufferSize, SPBM_SETLIMITS,
       MPFROMLONG( 10 ), MPFROMLONG( 3 ) );
      WinSendDlgItemMsg( win, SB_BufferSize, SPBM_SETCURRENTVALUE,
       MPFROMLONG( (LONG)globaloptions.audinterleave ), 0 );
      for ( i=0; i < AUDQUALSETTINGS; ++i )
      {
        mr = WinSendDlgItemMsg( win, DDB_Quality, LM_INSERTITEM,
         MPFROMSHORT( LIT_END ), MPFROMP( audqualstrings[i] ) );
      }

      switch ( globaloptions.audfreq )
      {
        case 8000:
          audqualnum = 0;
        break;
        case 11025:
          audqualnum = 1;
        break;
        case 22050:
          audqualnum = 2;
        break;
        case 33075:
          audqualnum = 3;
        break;
        case 44100:
          audqualnum = 4;
        break;
        default:
          myerrorlog( "Bad audio frequency setting.  Resetting to 22KHz." );
          audqualnum = 2;
        break;
      }

      WinSendDlgItemMsg( win, DDB_Quality, LM_SELECTITEM,
       MPFROMSHORT( audqualnum ), MPFROMSHORT( TRUE ) );

      WinCheckButton( win, CB_UseDART, 1 );
      WinEnableWindow( WinWindowFromID( win, CB_UseDART ), FALSE );
      // Only using DART is supported currently

      WinCheckButton( win, CB_ShareAudio, globaloptions.shareaudio );
      WinCheckButton( win, CB_EnableAudio, globaloptions.enableaudio );
    }
    break;
    case WM_SENSITIVECHECK:
    {
      char enableme = SHORT1FROMMP( mp2 );
      WinEnableWindow( WinWindowFromID( win, ST_FrameToBuffer ), enableme );
      WinEnableWindow( WinWindowFromID( win, SB_BufferSize ), enableme );
      WinEnableWindow( WinWindowFromID( win, ST_AudioQuality ), enableme );
      WinEnableWindow( WinWindowFromID( win, DDB_Quality ), enableme );
//      WinEnableWindow( WinWindowFromID( win, CB_UseDART ), enableme );
      WinEnableWindow( WinWindowFromID( win, CB_ShareAudio ), enableme );
    }
    break;
    case WM_COMMAND:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case DID_OK:
        {
          MRESULT mr;
          ULONG value;
          SHORT idx;

          WinSendDlgItemMsg( win, SB_BufferSize, SPBM_QUERYVALUE,
           MPFROMP( &value ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          globaloptions.audinterleave = value;

          mr = WinSendDlgItemMsg( win, DDB_Quality, LM_QUERYSELECTION,
            MPFROMSHORT( LIT_FIRST ), 0 );
          idx = SHORT1FROMMR( mr );
          globaloptions.audfreq = audqualnums[idx];
          globaloptions.usedart = WinQueryButtonCheckstate( win, CB_UseDART );
          globaloptions.shareaudio =
           WinQueryButtonCheckstate( win, CB_ShareAudio );
          globaloptions.enableaudio =
           WinQueryButtonCheckstate( win, CB_EnableAudio );

          OpenProfile();
          SaveAudioOptionsToProfile();
          CloseProfile();
        }
        break;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

void PopulateMGLModesArrays( HWND win )
{
  MRESULT mr;
  int i;
  char modename[ 80 ];

  WinSendDlgItemMsg( win, LB_MGLModes, LM_DELETEALL, 0, 0 );
  
  for ( i=0; MAME_modes[i].width; ++i )
  {
    sprintf( modename, "%d x %d, %d bits per pixel", MAME_modes[i].width,
     MAME_modes[i].height, MAME_modes[i].depth );
    mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_INSERTITEM,
     MPFROMSHORT( LIT_END ), MPFROMP( modename ) );
    WinSendDlgItemMsg( win, LB_MGLModes, LM_SETITEMHANDLE,
     MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMLONG( i ) );
  }
  WinSendDlgItemMsg( win, LB_MGLModes, LM_SELECTITEM,
   MPFROMSHORT( 0 ), MPFROMLONG( TRUE ) );
}

void InsertSorted( int newwidth, int newheight, int newdepth, int deleteitem )
{
  extern void DeallocVidModesIfNeeded( void );

  struct vidmode_descrip *newmodes;
  int nummodes, i, j;

  for ( nummodes=0; MAME_modes[nummodes].width; ++nummodes );

  if ( deleteitem != -1 )
  {
    nummodes--;
  }

  if ( newwidth == 999999 )
  {
    nummodes--;
  }

  newmodes = (struct vidmode_descrip *)
   malloc( sizeof( struct vidmode_descrip ) * (nummodes + 2) );

  j = 0;
  for ( i=0; MAME_modes[i].width; ++i )
  {
    if ( deleteitem == i ) continue;

    if ( MAME_modes[i].width == newwidth &&
         MAME_modes[i].height == newheight &&
         MAME_modes[i].depth == newdepth )
    {
      newwidth = 999999;
      newheight = 999999;
      newdepth = 999999;
    }
    // already in there, so don't add again

    if ( MAME_modes[i].width > newwidth ||
         (MAME_modes[i].width == newwidth &&
          MAME_modes[i].height > newheight) ||
         (MAME_modes[i].width == newwidth &&
          MAME_modes[i].height == newheight &&
          MAME_modes[i].depth > newdepth) )
    {
      // Insert our new item here
      newmodes[j].width = newwidth;
      newmodes[j].height = newheight;
      newmodes[j].depth = newdepth;
      ++j;
      newwidth = 999999;
      newheight = 999999;
      newdepth = 999999;
    }
    newmodes[j].width = MAME_modes[i].width;
    newmodes[j].height = MAME_modes[i].height;
    newmodes[j].depth = MAME_modes[i].depth;
    ++j;
  }
  if ( newwidth != 999999 )
  {
    newmodes[j].width = newwidth;
    newmodes[j].height = newheight;
    newmodes[j].depth = newdepth;
    ++j;
  }
  newmodes[j].width = 0;
  newmodes[j].height = 0;
  newmodes[j].depth = 0;

  DeallocVidModesIfNeeded();
  MAME_modes = newmodes;
  MGLSC_clientState()->allowedmodes = MAME_modes;
}

MRESULT EXPENTRY MyFileDialog( HWND win, ULONG message, MPARAM mp1, MPARAM mp2 )
{
  switch ( message )
  {
    case FDM_FILTER: // mp1 = pszFilename
    {
      HWND filetype;
      UCHAR tmpbuf[200];
      SHORT len;

      filetype = WinWindowFromID( win, DID_FILTER_CB );
      // File Type combo box
      len = WinQueryWindowText( filetype, 200, tmpbuf );
      if ( len )
      {
        if ( strcmp( "GAMode Executable (GAMode.Exe)", (char *)tmpbuf ) == 0 )
        {
          char *tmpptr = strrchr( (char *)mp1, '\\' );
          if ( !tmpptr ) tmpptr = (char *)mp1;
          if ( stricmp( tmpptr, "gamode.exe" ) != 0 )
          {
            return MRFROMLONG(FALSE);
          }
        }
      }

      return MRFROMLONG(TRUE);
    }
    break;
  }
  return WinDefFileDlgProc( win, message, mp1, mp2 );
}

#define WM_SDDSPAWNERROR WM_USER_MSG
#define WM_SDDSPAWNDONE  WM_USER_MSG + 1

FILEDLG fd = {0};

void SDDSpawnThread( void *parm )
{
  extern void DeallocVidModesIfNeeded( void );

  HWND win = (HWND) parm;
  char buf[1024], *ptr, *ptr2;
  FILE *gamode_output;
  int modewidth, modeheight, modedepth;

  sprintf( buf, "%s show", fd.szFullFile );
  gamode_output = popen( buf, "rt" );

  if ( !gamode_output )
  {
    WinPostMsg( win, WM_SDDSPAWNERROR, 0, 0 );
    _endthread();
    return;
  }

  do
  {
    ptr = fgets( buf, 1024, gamode_output );

    if ( strchr( buf, '@' ) == NULL ) continue;
    // Not a mode line
    if ( strchr( buf, 'T' ) != NULL ) continue;
    // Text modes

    ptr2 = strtok( buf, "x" );
    if ( !ptr2 )
    {
      myerrorlog( "Unexpected output from GAMode!:" );
      myerrorlog( "%s", buf );
      continue;
    }
    modewidth = atol( ptr2 );
    ptr2 = strtok( NULL, "x" );
    if ( !ptr2 )
    {
      myerrorlog( "Unexpected output from GAMode!:" );
      myerrorlog( "%s", buf );
      continue;
    }
    modeheight = atol( ptr2 );
    ptr2 = strtok( NULL, "@" );
    if ( !ptr2 )
    {
      myerrorlog( "Unexpected output from GAMode!:" );
      myerrorlog( "%s", buf );
      continue;
    }
    modedepth = atol( ptr2 );

    if ( modedepth != 8 && modedepth != 16 ) continue;
    if ( modewidth > 1600 || modeheight > 1200 ) continue;
    if ( modewidth < 200 || modeheight < 200 ) continue;
    // Weed out things that aren't accepted in my dialog box

    myerrorlog( "SDD reports video mode %d x %d %dbpp is available.", modewidth, modeheight, modedepth );

    InsertSorted( modewidth, modeheight, modedepth, -1 );
    // Will automatically resize array if needed and weed out duplicates
    // and, of course, sort the modes as they are added

  } while ( ptr );

  pclose( gamode_output );

  WinPostMsg( win, WM_SDDSPAWNDONE, 0, 0 );

  _endthread();
}

MRESULT EXPENTRY MGLProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
    {
      CenterThisWindow( win );
      WinCheckButton( win, CB_AllowCustom, globaloptions.customfs );
      WinCheckButton( win, CB_StretchBlit, globaloptions.stretchblit );
      WinSendDlgItemMsg( win, DDB_Depth, LM_INSERTITEM,
       MPFROMSHORT( LIT_END ), MPFROMP( "8 bpp" ) );
      WinSendDlgItemMsg( win, DDB_Depth, LM_INSERTITEM,
       MPFROMSHORT( LIT_END ), MPFROMP( "16 bpp" ) );
      WinSendDlgItemMsg( win, SB_Width, SPBM_SETLIMITS,
       MPFROMLONG( 1600 ), MPFROMLONG( 200 ) );
      WinSendDlgItemMsg( win, SB_Height, SPBM_SETLIMITS,
       MPFROMLONG( 1200 ), MPFROMLONG( 200 ) );
      PopulateMGLModesArrays( win );
    }
    break;
    case WM_CONTROL:
      switch ( SHORT1FROMMP(mp1) )
      {
        case LB_MGLModes:
          if ( SHORT2FROMMP(mp1) == LN_SELECT )
          {
            MRESULT mr;
            int modenum;

            mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYSELECTION,
             MPFROMSHORT( LIT_FIRST ), NULL );
            mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYITEMHANDLE,
             MPFROMSHORT( SHORT1FROMMR(mr) ), NULL );
            modenum = LONGFROMMR( mr );
            WinSendDlgItemMsg( win, SB_Width, SPBM_SETCURRENTVALUE,
             MPFROMLONG( MAME_modes[modenum].width ), 0 );
            WinSendDlgItemMsg( win, SB_Height, SPBM_SETCURRENTVALUE,
             MPFROMLONG( MAME_modes[modenum].height ), 0 );
            WinSendDlgItemMsg( win, DDB_Depth, LM_SELECTITEM,
             MPFROMSHORT( MAME_modes[modenum].depth == 8 ? 0 : 1 ),
             MPFROMLONG( TRUE ) );
          }
        break;
      }
    break;
    case WM_COMMAND:
      switch ( SHORT1FROMMP(mp1) )
      {
        case B_ModeAdd:
        {
          int newwidth, newheight, newdepth;
          MRESULT mr;

          WinSendDlgItemMsg( win, SB_Width, SPBM_QUERYVALUE,
           MPFROMP( &newwidth ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          WinSendDlgItemMsg( win, SB_Height, SPBM_QUERYVALUE,
           MPFROMP( &newheight ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          mr = WinSendDlgItemMsg( win, DDB_Depth, LM_QUERYSELECTION,
           MPFROMSHORT( LIT_FIRST ), NULL );
          newdepth = SHORT1FROMMR(mr) ? 16 : 8;

          InsertSorted( newwidth, newheight, newdepth, -1 );
          PopulateMGLModesArrays( win );
          return 0;
        }
        break;
        case B_ModeDelete:
        {
          int delitem;
          MRESULT mr;

          mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYSELECTION,
           MPFROMSHORT( LIT_FIRST ), NULL );
          mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYITEMHANDLE,
           MPFROMSHORT( SHORT1FROMMR(mr) ), NULL );
          delitem = LONGFROMMR( mr );

          InsertSorted( 999999, 999999, 999999, delitem );
          PopulateMGLModesArrays( win );
          return 0;
        }
        break;
        case B_ModeModify:
        {
          int delitem;
          int newwidth, newheight, newdepth;
          MRESULT mr;

          mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYSELECTION,
           MPFROMSHORT( LIT_FIRST ), NULL );
          mr = WinSendDlgItemMsg( win, LB_MGLModes, LM_QUERYITEMHANDLE,
           MPFROMSHORT( SHORT1FROMMR(mr) ), NULL );
          delitem = LONGFROMMR( mr );

          WinSendDlgItemMsg( win, SB_Width, SPBM_QUERYVALUE,
           MPFROMP( &newwidth ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          WinSendDlgItemMsg( win, SB_Height, SPBM_QUERYVALUE,
           MPFROMP( &newheight ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          mr = WinSendDlgItemMsg( win, DDB_Depth, LM_QUERYSELECTION,
           MPFROMSHORT( LIT_FIRST ), NULL );
          newdepth = SHORT1FROMMR(mr) ? 16 : 8;

          InsertSorted( newwidth, newheight, newdepth, delitem );
          PopulateMGLModesArrays( win );
          return 0;
        }
        break;
        case B_GetSDDSettings:
        {
          ULONG drivenum, drivemap;
          UCHAR drive[3] = { 'A', ':', 0 };
          char *filetypes[] = { "GAMode Executable (GAMode.Exe)", 0 };
          fd.cbSize = sizeof( FILEDLG );
          fd.fl = FDS_CENTER | FDS_OPEN_DIALOG;
          fd.pszTitle = (PSZ)"Looking for GAMode.Exe...";
          fd.pszOKButton = (PSZ)"Here it is!";
          fd.pfnDlgProc = MyFileDialog;
          fd.pszIType = (PSZ) filetypes[0];
          fd.papszITypeList = (PAPSZ) filetypes;

          DosQueryCurrentDisk( &drivenum, &drivemap );
          drive[0] += drivenum - 1;
          fd.pszIDrive = drive;

          WinFileDlg( HWND_DESKTOP, MGLSC_clientState()->clientwin, &fd );

          if ( fd.lReturn == DID_OK )
          {
            WinEnableWindow( WinWindowFromID( win, B_GetSDDSettings ), FALSE );
            WinEnableWindow( WinWindowFromID( win, B_ModeAdd ), FALSE );
            WinEnableWindow( WinWindowFromID( win, B_ModeModify ), FALSE );
            WinEnableWindow( WinWindowFromID( win, B_ModeDelete ), FALSE );
            WinEnableWindow( WinWindowFromID( win, LB_MGLModes ), FALSE );
            WinEnableWindow( WinWindowFromID( win, SB_Width ), FALSE );
            WinEnableWindow( WinWindowFromID( win, SB_Height ), FALSE );
            WinEnableWindow( WinWindowFromID( win, DDB_Depth ), FALSE );

            _beginthread( (void(*)(void*))SDDSpawnThread, NULL, 16384,
             (void *)win );
          }
          return 0;
        }
        break;
        case DID_OK:
          globaloptions.customfs =
           WinQueryButtonCheckstate( win, CB_AllowCustom );
          globaloptions.stretchblit =
           WinQueryButtonCheckstate( win, CB_StretchBlit );

          MGLSC_clientState()->stretchblit = globaloptions.stretchblit;
          MGLSC_clientState()->custommodes = globaloptions.customfs;

          OpenProfile();
          SaveMGLOptionsToProfile();
          CloseProfile();
        break;
        case DID_CANCEL:
          OpenProfile();
          LoadMGLOptionsFromProfile();
          CloseProfile();
          // Restore the MGL_modes array if needed
        break;
      }
    break;
    case WM_SDDSPAWNERROR:
      WinMessageBox( HWND_DESKTOP, win,
       "Unable to execute or read the output from GAMode.Exe!  Cannot get the settings from Scitech Display Doctor.  Sorry!",
       "Critical error running GAMode.Exe", 0,
       MB_OK | MB_ICONEXCLAMATION | MB_APPLMODAL | MB_MOVEABLE );
      WinPostMsg( win, WM_SDDSPAWNDONE, 0, 0 );
    break;
    case WM_SDDSPAWNDONE:
      WinEnableWindow( WinWindowFromID( win, B_GetSDDSettings ), TRUE );
      WinEnableWindow( WinWindowFromID( win, B_ModeAdd ), TRUE );
      WinEnableWindow( WinWindowFromID( win, B_ModeModify ), TRUE );
      WinEnableWindow( WinWindowFromID( win, B_ModeDelete ), TRUE );
      WinEnableWindow( WinWindowFromID( win, LB_MGLModes ), TRUE );
      WinEnableWindow( WinWindowFromID( win, SB_Width ), TRUE );
      WinEnableWindow( WinWindowFromID( win, SB_Height ), TRUE );
      WinEnableWindow( WinWindowFromID( win, DDB_Depth ), TRUE );
      PopulateMGLModesArrays( win );
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

MRESULT EXPENTRY SetInputProc( HWND win, ULONG msg, MPARAM mp1, MPARAM mp2 )
{
  switch ( msg )
  {
    case WM_INITDLG:
    {
      extern struct KeyboardInfo keylist[];
      extern char rapidkeys[];
      MRESULT mr;
      int i;

      CenterThisWindow( win );

      WinSendDlgItemMsg( win, DDB_SettingsApplyTo, LM_INSERTITEM,
       MPFROMSHORT( LIT_END ), MPFROMP( "All games (default settings)" ) );
      WinSendDlgItemMsg( win, DDB_SettingsApplyTo, LM_SELECTITEM,
       MPFROMSHORT( 0 ), MPFROMSHORT( TRUE ) );
      if ( game_is_running )
      {
        extern int game_to_run;

        WinSendDlgItemMsg( win, DDB_SettingsApplyTo, LM_INSERTITEM,
         MPFROMSHORT( LIT_END ),
         MPFROMP( drivers[game_to_run]->description ) );

        WinSendDlgItemMsg( win, DDB_SettingsApplyTo, LM_SELECTITEM,
         MPFROMSHORT( 1 ), MPFROMSHORT( TRUE ) );
      }

      WinSendDlgItemMsg( win, SB_RapidRate, SPBM_SETLIMITS,
       MPFROMLONG( 30 ), MPFROMLONG( 2 ) );
      WinSendDlgItemMsg( win, SB_RapidRate, SPBM_SETCURRENTVALUE,
       MPFROMLONG( (LONG)globaloptions.rapidrate ), 0 );

      WinCheckButton( win, CB_InterceptALT, globaloptions.altbypass );
      WinCheckButton( win, CB_EnableMouse, globaloptions.enablemouse );
      WinCheckButton( win, CB_MouseGrab, globaloptions.mousegrab );

      if ( !globaloptions.enablemouse )
      {
        WinEnableWindow( WinWindowFromID( win, CB_MouseGrab), FALSE );
      }

      OldCheckBoxProc = WinSubclassWindow(
       WinWindowFromID( win, CB_EnableMouse ), SensitiveCheckBox );

      for ( i=0; keylist[i].name; ++i )
      {
        mr = WinSendDlgItemMsg( win, LB_RapidKeys, LM_INSERTITEM,
         MPFROMSHORT( LIT_SORTASCENDING ), MPFROMP( keylist[i].name ) );
        WinSendDlgItemMsg( win, LB_RapidKeys, LM_SETITEMHANDLE,
         MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMLONG( i ) );

        if ( rapidkeys[keylist[i].code] )
        {
          WinSendDlgItemMsg( win, LB_RapidKeys, LM_SELECTITEM,
           MPFROMSHORT( SHORT1FROMMR(mr) ), MPFROMLONG( TRUE ) );
        }
      }
    }
    break;
    case WM_SENSITIVECHECK:
      WinEnableWindow( WinWindowFromID( win, CB_MouseGrab ),
       SHORT1FROMMP(mp2) );
    break;
    case WM_CONTROL:
      switch ( SHORT1FROMMP(mp1) )
      {
        case DDB_SettingsApplyTo:
          if ( SHORT2FROMMP(mp1) == LN_SELECT )
          {
            extern int game_to_run;
            extern struct KeyboardInfo keylist[];
            extern char rapidkeys[];

            MRESULT mr;
            int i;

            mr = WinSendDlgItemMsg( win, DDB_SettingsApplyTo,
             LM_QUERYSELECTION, MPFROMSHORT( LIT_FIRST ), NULL );

            OpenProfile();
            if ( SHORT1FROMMR( mr ) == 0 )
            {
              // Default settings
              LoadRapidKeysForGame( -1 );
              LoadInputOptionsFromProfile( -1 );
            } else {
              // Game-specific settings
              LoadRapidKeysForGame( game_to_run );
              LoadInputOptionsFromProfile( game_to_run );
            }
            CloseProfile();

            for ( i=0; keylist[i].name; ++i )
            {
              mr = WinSendDlgItemMsg( win, LB_RapidKeys, LM_QUERYITEMHANDLE,
               MPFROMSHORT( i ), NULL );
              WinSendDlgItemMsg( win, LB_RapidKeys, LM_SELECTITEM,
               MPFROMSHORT( i ),
               MPFROMLONG( rapidkeys[ keylist[LONGFROMMR(mr)].code ] ) );
            }

            WinCheckButton( win, CB_InterceptALT, globaloptions.altbypass );
            WinCheckButton( win, CB_EnableMouse, globaloptions.enablemouse );
            WinCheckButton( win, CB_MouseGrab, globaloptions.mousegrab );
          }
        break;
      }
    break;
    case WM_COMMAND:
      switch ( SHORT1FROMMP( mp1 ) )
      {
        case DID_OK:
        {
          extern int game_to_run;
          extern struct KeyboardInfo keylist[];
          extern char rapidkeys[];

          MRESULT mr;
          SHORT idx;
          ULONG value;

          memset( rapidkeys, 0, 256 );

          mr = WinSendDlgItemMsg( win, LB_RapidKeys, LM_QUERYSELECTION,
           MPFROMSHORT( LIT_FIRST ), NULL );
          idx = SHORT1FROMMR( mr );

          while ( idx != LIT_END )
          {
            mr = WinSendDlgItemMsg( win, LB_RapidKeys, LM_QUERYITEMHANDLE,
             MPFROMSHORT( idx ), NULL );
            rapidkeys[ keylist[LONGFROMMR(mr)].code ] = 1;
            mr = WinSendDlgItemMsg( win, LB_RapidKeys, LM_QUERYSELECTION,
             MPFROMSHORT( idx ), NULL );
            idx = SHORT1FROMMR( mr );
          }

          mr = WinSendDlgItemMsg( win, DDB_SettingsApplyTo,
           LM_QUERYSELECTION, MPFROMSHORT( LIT_FIRST ), NULL );

          WinSendDlgItemMsg( win, SB_RapidRate, SPBM_QUERYVALUE,
           MPFROMP( &value ), MPFROM2SHORT( 0, SPBQ_ALWAYSUPDATE ) );
          globaloptions.rapidrate = value;

          globaloptions.altbypass =
           WinQueryButtonCheckstate( win, CB_InterceptALT );
          globaloptions.enablemouse =
           WinQueryButtonCheckstate( win, CB_EnableMouse );
          globaloptions.mousegrab =
           WinQueryButtonCheckstate( win, CB_MouseGrab );

          OpenProfile();
          if ( SHORT1FROMMR(mr) == 0 )
          {
            SaveRapidKeysForGame( -1 );
            SaveInputOptionsToProfile( -1 );
            
            if ( game_is_running )
            {
              SaveRapidKeysForGame( game_to_run );
              SaveInputOptionsToProfile( game_to_run );
            }
            // Save as defaults and settings for this game
            // Otherwise just save as defaults
          } else {
            SaveRapidKeysForGame( game_to_run );
            SaveInputOptionsToProfile( game_to_run );
            // Save as just settings for this game
          }
          CloseProfile();
        }
        break;
        case DID_CANCEL:
          OpenProfile();
          if ( game_is_running )
          {
            extern int game_to_run;

            LoadRapidKeysForGame( game_to_run );
          } else {
            LoadRapidKeysForGame( -1 );
          }
          CloseProfile();
        break;
      }
    break;
  }
  return WinDefDlgProc( win, msg, mp1, mp2 );
}

void WindowCommandProc( HWND win, ULONG cmd )
{
  switch ( cmd )
  {
    case FileExit:
      WinPostMsg( win, WM_CLOSE, 0, 0 );
    break;
    case FileQuickList:
      WinDlgBox( HWND_DESKTOP, win, QuickListProc, 0, QuickListWindow, NULL );
    break;
    case FileChangePaths:
      WinDlgBox( HWND_DESKTOP, win, ChangePathsProc, 0,
       SearchPathWindow, NULL );
    break;
    case LogViewDebug:
      WinShowWindow( logwin, TRUE );
      WinSetFocus( HWND_DESKTOP, logwin );
    break;
    case LogViewCore:
      if ( !corelogwin )
      {
        corelogwin = WinLoadDlg( HWND_DESKTOP, HWND_DESKTOP, LogWindowProc,
          0, LogWindow, "MAME Core Log" );
        WinShowWindow( corelogwin, TRUE );
      } else {
        WinShowWindow( corelogwin, TRUE );
      }
      WinSetFocus( HWND_DESKTOP, corelogwin );
    break;
    case Window1x:
      WinPostMsg( win, WM_SETWINSIZE, MPFROM2SHORT( 1000, 1000 ), 0 );
    break;
    case Window2x:
      WinPostMsg( win, WM_SETWINSIZE, MPFROM2SHORT( 2000, 2000 ), 0 );
    break;
    case Window4x:
      WinPostMsg( win, WM_SETWINSIZE, MPFROM2SHORT( 4000, 4000 ), 0 );
    break;
    case WindowFS:
    {
      extern void InputHandler( InputEventType, short, short );
      // Let the keyboard handler do its thing with the FS switch
      InputHandler( MGLSC_KEYBOARD_MAKE, KB_F11, 0 );
    }
    break;
    case SettingsFrameRate:
      WinDlgBox( HWND_DESKTOP, win, FrameRateProc, 0, FrameRateWindow, NULL );
    break;
    case SettingsAudio:
      WinDlgBox( HWND_DESKTOP, win, AudioProc, 0, AudioWindow, NULL );
    break;
    case SettingsMGL:
      WinDlgBox( HWND_DESKTOP, win, MGLProc, 0, MGLWindow, NULL );
    break;
    case SettingsAutoPause:
      globaloptions.autopause = 1 - globaloptions.autopause;
      OpenProfile();
      SaveMiscOptionsToProfile();
      CloseProfile();
      WinCheckMenuItem( WinWindowFromID( MGLSC_clientState()->framewin, FID_MENU ),
       SettingsAutoPause, globaloptions.autopause );
    break;
    case SettingsSimLED:
    {
      extern void useKeyboardLEDs( char );

      globaloptions.simled = 1 - globaloptions.simled;
      useKeyboardLEDs( globaloptions.simled );
      OpenProfile();
      SaveMiscOptionsToProfile();
      CloseProfile();
      WinCheckMenuItem( WinWindowFromID( MGLSC_clientState()->framewin, FID_MENU ),
       SettingsSimLED, globaloptions.simled );
    }
    break;
    case SettingsInput:
      WinDlgBox( HWND_DESKTOP, win, SetInputProc, 0, InputWindow, NULL );
    break;
    case HelpAbout:
      WinDlgBox( HWND_DESKTOP, win, AboutBoxProc, 0, AboutWindow, NULL );
    break;
  }
}
