#ifndef OPTIONS_H_INCLUDED
#define OPTIONS_H_INCLUDED

#include "fileio.h"

enum CommandLineOptionType
{
        KEYWORD_ONLY, KEYWORD_AND_VALUE, KEYWORD_AND_LIST, KEYWORD_BOGUS
};

struct CommandLineOptions
{
        char *keyword;
        enum CommandLineOptionType type;
        char *description;
        void (*action) ( char * );
};

extern struct CommandLineOptions cli_options[];
// Instantiated in parseargv.c

struct GlobalOptions
{
        char shareaudio, enableaudio, usedart;
        char audinterleave, autoskip, mskip, usetimer0;
        char stretchblit, customfs, autopause, rapidrate;
        char enablemouse, mousegrab, altbypass, simled;
        unsigned long audfreq;
        char *sddpath;

        struct MAMEpaths *samplepath;
        struct MAMEpaths *rompath;
        struct MAMEpaths *statepath;
        struct MAMEpaths *artpath;
        struct MAMEpaths *capturepath;
        struct MAMEpaths *curpath;
};

extern struct GlobalOptions globaloptions;
// Instantiated in os2.c

#endif

