#include "options.h"

#ifndef PROFILE_H_INCLUDED
#define PROFILE_H_INCLUDED

extern char *availabledrivers;
extern int totaldrivers;

#define DRIVER_FLAGS_AVAILABLE 1
#define DRIVER_FLAGS_FAVORITE  2
#define DRIVER_FLAGS_DANGEROUS 4

void OpenProfile( void );
void CloseProfile( void );

void LoadPathsFromProfile( void );
void LoadAvailableGamesFromProfile( void );
void LoadFavoriteGamesFromProfile( void );
void LoadFrameRateOptionsFromProfile( void );
void LoadAudioOptionsFromProfile( void );
void LoadMGLOptionsFromProfile( void );
void LoadMiscOptionsFromProfile( void );
void LoadInputOptionsFromProfile( int game );
void LoadRapidKeysForGame( int game );

void SavePathsToProfile( void );
void SaveAvailableGamesToProfile( void );
void SaveFavoriteGamesToProfile( void );
void SaveFrameRateOptionsToProfile( void );
void SaveAudioOptionsToProfile( void );
void SaveMGLOptionsToProfile( void );
void SaveMiscOptionsToProfile( void );
void SaveInputOptionsToProfile( int game );
void SaveRapidKeysForGame( int game );

void MarkGamePotentiallyDangerous( int game );
char CheckIfGameIsDangerous( int game );
void ConfirmGameIsNotDangerous( int game );

int WasSplashScreenShown( void );
void SplashScreenWasShown( void );

#endif
