/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack;

import java.io.InputStream;
import java.text.MessageFormat;
import java.util.TreeMap;
import java.util.Vector;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;

public class LocaleDatabase
extends TreeMap {
    static final long serialVersionUID = 4941525634108401848L;

    public LocaleDatabase(InputStream in) throws Exception {
        this.add(in);
    }

    public void add(InputStream in) throws Exception {
        StdXMLParser parser = new StdXMLParser();
        parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
        parser.setReader(new StdXMLReader(in));
        parser.setValidator(new NonValidator());
        XMLElement data = (XMLElement)parser.parse();
        if (!"langpack".equalsIgnoreCase(data.getName())) {
            throw new Exception("this is not an IzPack XML langpack file");
        }
        Vector children = data.getChildren();
        int size = children.size();
        for (int i = 0; i < size; ++i) {
            XMLElement e = (XMLElement)children.get(i);
            String text = e.getContent();
            if (text != null && !"".equals(text)) {
                this.put(e.getAttribute("id"), text.trim());
                continue;
            }
            this.put(e.getAttribute("id"), e.getAttribute("txt"));
        }
    }

    public String getString(String key) {
        String val = (String)this.get(key);
        if (val == null) {
            val = key;
        }
        return val;
    }

    public String getString(String key, String[] variables) {
        for (int i = 0; i < variables.length; ++i) {
            if (!variables[i].startsWith("$")) continue;
            String curArg = variables[i];
            curArg = curArg.startsWith("${") ? curArg.substring(2, curArg.length() - 1) : curArg.substring(1);
            variables[i] = this.getString(curArg);
        }
        return MessageFormat.format(this.getString(key), variables);
    }
}

