/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.installer;

import com.izforge.izpack.LocaleDatabase;
import com.izforge.izpack.Pack;
import com.izforge.izpack.PackFile;
import com.izforge.izpack.UpdateCheck;
import com.izforge.izpack.event.InstallerListener;
import com.izforge.izpack.installer.AutomatedInstallData;
import com.izforge.izpack.installer.IUnpacker;
import com.izforge.izpack.installer.ResourceManager;
import com.izforge.izpack.installer.UninstallData;
import com.izforge.izpack.installer.Unpacker;
import com.izforge.izpack.rules.RulesEngine;
import com.izforge.izpack.util.AbstractUIProgressHandler;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.IoHelper;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Stack;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import java.util.zip.ZipOutputStream;
import org.apache.regexp.RE;
import org.apache.regexp.RECompiler;
import org.apache.regexp.RESyntaxException;

public abstract class UnpackerBase
implements IUnpacker {
    protected AutomatedInstallData idata;
    protected AbstractUIProgressHandler handler;
    protected UninstallData udata;
    protected VariableSubstitutor vs;
    protected File absolute_installpath;
    protected LocaleDatabase langpack = null;
    protected boolean result = true;
    protected static HashMap instances = new HashMap();
    protected static boolean interruptDesired = false;
    protected static boolean discardInterrupt = false;
    protected static final String LANG_FILE_NAME = "packsLang.xml";
    public static final String ALIVE = "alive";
    public static final String INTERRUPT = "doInterrupt";
    public static final String INTERRUPTED = "interruppted";
    protected RulesEngine rules;

    public UnpackerBase(AutomatedInstallData idata, AbstractUIProgressHandler handler) {
        try {
            String resource = "packsLang.xml_" + idata.localeISO3;
            this.langpack = new LocaleDatabase(ResourceManager.getInstance().getInputStream(resource));
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        this.idata = idata;
        this.handler = handler;
        this.vs = new VariableSubstitutor(idata.getVariables());
    }

    public void setRules(RulesEngine rules) {
        this.rules = rules;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static HashMap getRunningInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            return (HashMap)instances.clone();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void addToInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            instances.put(this, ALIVE);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void removeFromInstances() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            instances.remove(this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void setInterruptAll() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Iterator iter = instances.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (!instances.get(key).equals(ALIVE)) continue;
                instances.put(key, INTERRUPT);
            }
            UnpackerBase.setInterruptDesired(true);
        }
    }

    public static boolean interruptAll(long waitTime) {
        long t0 = System.currentTimeMillis();
        if (UnpackerBase.isDiscardInterrupt()) {
            return false;
        }
        UnpackerBase.setInterruptAll();
        while (!UnpackerBase.isInterruptReady()) {
            if (System.currentTimeMillis() - t0 > waitTime) {
                return true;
            }
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {}
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static boolean isInterruptReady() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Iterator iter = instances.keySet().iterator();
            while (iter.hasNext()) {
                Object key = iter.next();
                if (instances.get(key).equals(INTERRUPTED)) continue;
                return false;
            }
            return true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean performInterrupted() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Object doIt = instances.get(this);
            if (doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED))) {
                instances.put(this, INTERRUPTED);
                this.result = false;
                return true;
            }
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean shouldInterrupt() {
        HashMap hashMap = instances;
        synchronized (hashMap) {
            Object doIt = instances.get(this);
            return doIt != null && (doIt.equals(INTERRUPT) || doIt.equals(INTERRUPTED));
            {
            }
        }
    }

    public boolean getResult() {
        return this.result;
    }

    private boolean fileMatchesOnePattern(String filename, ArrayList patterns) {
        Iterator inc_it = patterns.iterator();
        while (inc_it.hasNext()) {
            RE pattern = (RE)inc_it.next();
            if (!pattern.match(filename)) continue;
            return true;
        }
        return false;
    }

    private List preparePatterns(ArrayList list, RECompiler recompiler) {
        ArrayList<RE> result = new ArrayList<RE>();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            String element = (String)iter.next();
            if (element == null || element.length() <= 0) continue;
            File f = new File(element = this.vs.substitute(element, "plain"));
            if (!f.isAbsolute()) {
                element = new File(this.absolute_installpath, element).toString();
            }
            StringBuffer element_re = new StringBuffer();
            int lookahead = -1;
            int pos = 0;
            block8: while (pos < element.length()) {
                char c;
                if (lookahead != -1) {
                    c = (char)lookahead;
                    lookahead = -1;
                } else {
                    c = element.charAt(pos++);
                }
                switch (c) {
                    case '/': {
                        element_re.append(File.separator);
                        continue block8;
                    }
                    case '.': 
                    case '\\': {
                        element_re.append("\\");
                        element_re.append(c);
                        continue block8;
                    }
                    case '*': {
                        if (pos == element.length()) {
                            element_re.append("[^").append(File.separator).append("]*");
                            continue block8;
                        }
                        if ((lookahead = (int)element.charAt(pos++)) == 42) {
                            element_re.append(".*");
                            lookahead = -1;
                            continue block8;
                        }
                        element_re.append("[^").append(File.separator).append("]*");
                        continue block8;
                    }
                }
                element_re.append(c);
            }
            element_re.append('$');
            try {
                result.add(new RE(recompiler.compile(element_re.toString())));
            }
            catch (RESyntaxException e) {
                this.handler.emitNotification("internal error: pattern \"" + element + "\" produced invalid RE \"" + f.getPath() + "\"");
            }
        }
        return result;
    }

    protected void informListeners(List[] customActions, int action, Object firstParam, Object secondParam, Object thirdParam) throws Exception {
        List listener = null;
        switch (action) {
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                listener = customActions[customActions.length - 1];
                break;
            }
            default: {
                listener = customActions[0];
            }
        }
        if (listener == null) {
            return;
        }
        Iterator iter = listener.iterator();
        while (iter.hasNext()) {
            if (this.shouldInterrupt()) {
                return;
            }
            InstallerListener il = (InstallerListener)iter.next();
            switch (action) {
                case 1: {
                    il.beforeFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 2: {
                    il.afterFile((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 3: {
                    il.beforeDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 4: {
                    il.afterDir((File)firstParam, (PackFile)secondParam);
                    break;
                }
                case 5: {
                    il.beforePack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 6: {
                    il.afterPack((Pack)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 7: {
                    il.beforePacks((AutomatedInstallData)firstParam, (Integer)secondParam, (AbstractUIProgressHandler)thirdParam);
                    break;
                }
                case 8: {
                    il.afterPacks((AutomatedInstallData)firstParam, (AbstractUIProgressHandler)secondParam);
                }
            }
        }
    }

    protected List[] getCustomActions() {
        int i;
        String[] listenerNames = AutomatedInstallData.CUSTOM_ACTION_TYPES;
        List[] retval = new List[listenerNames.length + 1];
        for (i = 0; i < listenerNames.length; ++i) {
            retval[i] = (List)this.idata.customData.get(listenerNames[i]);
            if (retval[i] != null) continue;
            retval[i] = new ArrayList();
        }
        if (retval[0].size() > 0) {
            i = retval.length - 1;
            retval[i] = new ArrayList();
            Iterator iter = retval[0].iterator();
            while (iter.hasNext()) {
                InstallerListener li = (InstallerListener)iter.next();
                if (!li.isFileListener()) continue;
                retval[i].add(li);
            }
        }
        return retval;
    }

    protected boolean mkDirsWithEnhancement(File dest, PackFile pf, List[] customActions) throws Exception {
        String path = "unknown";
        if (dest != null) {
            path = dest.getAbsolutePath();
        }
        if (dest != null && !dest.exists() && dest.getParentFile() != null) {
            if (dest.getParentFile().exists()) {
                this.informListeners(customActions, 3, dest, pf, null);
            }
            if (!dest.mkdir()) {
                this.mkDirsWithEnhancement(dest.getParentFile(), pf, customActions);
                if (!dest.mkdir()) {
                    dest = null;
                }
            }
            this.informListeners(customActions, 4, dest, pf, null);
        }
        if (dest == null) {
            this.handler.emitError("Error creating directories", "Could not create directory\n" + path);
            this.handler.stopAction();
            return false;
        }
        return true;
    }

    public static synchronized boolean isDiscardInterrupt() {
        return discardInterrupt;
    }

    public static synchronized void setDiscardInterrupt(boolean di) {
        discardInterrupt = di;
        UnpackerBase.setInterruptDesired(false);
    }

    public static boolean isInterruptDesired() {
        return interruptDesired;
    }

    private static void setInterruptDesired(boolean interruptDesired) {
        UnpackerBase.interruptDesired = interruptDesired;
    }

    protected void putUninstaller() throws Exception {
        ZipOutputStream outJar;
        InputStream[] in = new InputStream[2];
        in[0] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller");
        if (in[0] == null) {
            return;
        }
        in[1] = UnpackerBase.class.getResourceAsStream("/res/IzPack.uninstaller-ext");
        String dest = IoHelper.translatePath("$INSTALL_PATH", this.vs) + File.separator + "Uninstaller";
        String jar = dest + File.separator + this.idata.info.getUninstallerName();
        File pathMaker = new File(dest);
        pathMaker.mkdirs();
        this.udata.setUninstallerJarFilename(jar);
        this.udata.setUninstallerPath(dest);
        FileOutputStream out = new FileOutputStream(jar);
        BufferedOutputStream bos = new BufferedOutputStream(out);
        this.idata.uninstallOutJar = outJar = new ZipOutputStream(bos);
        outJar.setLevel(9);
        this.udata.addFile(jar, true);
        HashSet<String> doubles = new HashSet<String>();
        for (int i = 0; i < in.length; ++i) {
            if (in[i] == null) continue;
            ZipInputStream inRes = new ZipInputStream(in[i]);
            ZipEntry zentry = inRes.getNextEntry();
            while (zentry != null) {
                if (!doubles.contains(zentry.getName())) {
                    doubles.add(zentry.getName());
                    outJar.putNextEntry(new ZipEntry(zentry.getName()));
                    int unc = inRes.read();
                    while (unc != -1) {
                        outJar.write(unc);
                        unc = inRes.read();
                    }
                    inRes.closeEntry();
                    outJar.closeEntry();
                }
                zentry = inRes.getNextEntry();
            }
            inRes.close();
        }
        InputStream in2 = Unpacker.class.getResourceAsStream("/langpacks/" + this.idata.localeISO3 + ".xml");
        outJar.putNextEntry(new ZipEntry("langpack.xml"));
        int read = in2.read();
        while (read != -1) {
            outJar.write(read);
            read = in2.read();
        }
        outJar.closeEntry();
    }

    protected void handleAdditionalUninstallData(UninstallData udata, List[] customData) {
        udata.addAdditionalData("__uninstallLibs__", customData[2]);
        udata.addAdditionalData("uninstallerListeners", customData[1]);
        udata.addAdditionalData("uninstallerJars", customData[3]);
    }

    public abstract void run();

    protected void performUpdateChecks(ArrayList updatechecks) {
        File f;
        ArrayList include_patterns = new ArrayList();
        ArrayList exclude_patterns = new ArrayList();
        RECompiler recompiler = new RECompiler();
        this.absolute_installpath = new File(this.idata.getInstallPath()).getAbsoluteFile();
        Iterator iter = updatechecks.iterator();
        while (iter.hasNext()) {
            UpdateCheck uc = (UpdateCheck)iter.next();
            if (uc.includesList != null) {
                include_patterns.addAll(this.preparePatterns(uc.includesList, recompiler));
            }
            if (uc.excludesList == null) continue;
            exclude_patterns.addAll(this.preparePatterns(uc.excludesList, recompiler));
        }
        if (include_patterns.size() == 0) {
            return;
        }
        TreeSet<String> installed_files = new TreeSet<String>();
        Iterator if_it = this.udata.getInstalledFilesList().iterator();
        while (if_it.hasNext()) {
            String fname = (String)if_it.next();
            f = new File(fname);
            if (!f.isAbsolute()) {
                f = new File(this.absolute_installpath, fname);
            }
            installed_files.add(f.getAbsolutePath());
        }
        Stack<File> scanstack = new Stack<File>();
        ArrayList<File> files_to_delete = new ArrayList<File>();
        try {
            scanstack.add(this.absolute_installpath);
            while (!scanstack.empty()) {
                f = (File)scanstack.pop();
                File[] files = f.listFiles();
                if (files == null) {
                    throw new IOException(f.getPath() + "is not a directory!");
                }
                for (int i = 0; i < files.length; ++i) {
                    File newf = files[i];
                    String newfname = newf.getPath();
                    if (installed_files.contains(newfname)) continue;
                    if (this.fileMatchesOnePattern(newfname, include_patterns) && !this.fileMatchesOnePattern(newfname, exclude_patterns)) {
                        files_to_delete.add(newf);
                    }
                    if (!newf.isDirectory()) continue;
                    scanstack.push(newf);
                }
            }
        }
        catch (IOException e) {
            this.handler.emitError("error while performing update checks", e.toString());
        }
        Iterator f_it = files_to_delete.iterator();
        while (f_it.hasNext()) {
            File f2 = (File)f_it.next();
            if (f2.isDirectory()) continue;
            f2.delete();
        }
    }

    public void writeInstallationInformation() throws IOException, ClassNotFoundException {
        Debug.trace("writing installation information");
        String installdir = this.idata.getInstallPath();
        ArrayList<Pack> installedpacks = new ArrayList<Pack>(this.idata.selectedPacks);
        File installationinfo = new File(installdir + File.separator + ".installationinformation");
        if (!installationinfo.exists()) {
            Debug.trace("creating info file" + installationinfo.getAbsolutePath());
            installationinfo.createNewFile();
        } else {
            Debug.trace("installation information found");
            FileInputStream fin = new FileInputStream(installationinfo);
            ObjectInputStream oin = new ObjectInputStream(fin);
            List packs = (List)oin.readObject();
            Iterator iterator = packs.iterator();
            while (iterator.hasNext()) {
                Pack pack = (Pack)iterator.next();
                installedpacks.add(pack);
            }
            oin.close();
            fin.close();
        }
        FileOutputStream fout = new FileOutputStream(installationinfo);
        ObjectOutputStream oout = new ObjectOutputStream(fout);
        oout.writeObject(installedpacks);
        oout.writeObject(this.idata.variables);
        Debug.trace("done.");
        oout.close();
        fout.close();
    }
}

