/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.ExecutableFile;
import com.izforge.izpack.util.AbstractUIHandler;
import com.izforge.izpack.util.Console;
import com.izforge.izpack.util.Debug;
import com.izforge.izpack.util.FileUtil;
import com.izforge.izpack.util.MonitorInputStream;
import com.izforge.izpack.util.OsConstraint;
import com.izforge.izpack.util.OsVersion;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

public class FileExecutor {
    private static final String JAR_FILE_SUFFIX = ".jar";
    private Collection files;

    private boolean stopThread(Thread t, MonitorInputStream m) {
        m.doStop();
        long softTimeout = 1000L;
        try {
            t.join(softTimeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        if (!t.isAlive()) {
            return true;
        }
        t.interrupt();
        long hardTimeout = 1000L;
        try {
            t.join(hardTimeout);
        }
        catch (InterruptedException e) {
            // empty catch block
        }
        return !t.isAlive();
    }

    public FileExecutor(Collection files) {
        this.files = files;
    }

    public FileExecutor() {
        this.files = null;
    }

    public static String getExecOutput(String[] aCommandLine) {
        return FileExecutor.getExecOutput(aCommandLine, false);
    }

    public static String getExecOutput(String[] aCommandLine, boolean forceToGetStdOut) {
        FileExecutor fe = new FileExecutor();
        String[] execOut = new String[2];
        int execResult = fe.executeCommand(aCommandLine, execOut);
        if (execResult == 0) {
            return execOut[0];
        }
        if (forceToGetStdOut) {
            return execOut[0];
        }
        return execOut[1];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int executeCommand(String[] params, String[] output) {
        StringBuffer retval = new StringBuffer();
        retval.append("executeCommand\n");
        if (params != null) {
            for (int i = 0; i < params.length; ++i) {
                retval.append("\tparams: ").append(params[i]);
                retval.append("\n");
            }
        }
        Process process = null;
        MonitorInputStream outMonitor = null;
        MonitorInputStream errMonitor = null;
        Thread t1 = null;
        Thread t2 = null;
        int exitStatus = -1;
        Debug.trace(retval);
        try {
            process = Runtime.getRuntime().exec(params);
            boolean console = false;
            if (console) {
                Console c = new Console(process);
                output[0] = c.getOutputData();
                output[1] = c.getErrorData();
                exitStatus = process.exitValue();
            } else {
                StringWriter outWriter = new StringWriter();
                StringWriter errWriter = new StringWriter();
                InputStreamReader or = new InputStreamReader(process.getInputStream());
                InputStreamReader er = new InputStreamReader(process.getErrorStream());
                outMonitor = new MonitorInputStream(or, outWriter);
                errMonitor = new MonitorInputStream(er, errWriter);
                t1 = new Thread(outMonitor);
                t2 = new Thread(errMonitor);
                t1.setDaemon(true);
                t2.setDaemon(true);
                t1.start();
                t2.start();
                exitStatus = process.waitFor();
                t1.join();
                t2.join();
                output[0] = outWriter.toString();
                Debug.trace("stdout:");
                Debug.trace(output[0]);
                output[1] = errWriter.toString();
                Debug.trace("stderr:");
                Debug.trace(output[1]);
            }
            Debug.trace("exit status: " + Integer.toString(exitStatus));
        }
        catch (InterruptedException e) {
            if (Debug.tracing()) {
                e.printStackTrace(System.err);
            }
            this.stopThread(t1, outMonitor);
            this.stopThread(t2, errMonitor);
            output[0] = "";
            output[1] = e.getMessage() + "\n";
        }
        catch (IOException e) {
            if (Debug.tracing()) {
                e.printStackTrace(System.err);
            }
            output[0] = "";
            output[1] = e.getMessage() + "\n";
        }
        finally {
            if (process != null) {
                process.destroy();
            }
        }
        return exitStatus;
    }

    public int executeFiles(int currentStage, AbstractUIHandler handler) {
        int exitStatus = 0;
        String[] output = new String[2];
        String permissions = "a+x";
        Iterator efileIterator = this.files.iterator();
        while (exitStatus == 0 && efileIterator.hasNext()) {
            ExecutableFile efile = (ExecutableFile)efileIterator.next();
            boolean deleteAfterwards = !efile.keepFile;
            File file = new File(efile.path);
            Debug.trace("handling executable file " + efile);
            if (!OsConstraint.oneMatchesCurrentSystem(efile.osList)) continue;
            if (0 == efile.type && currentStage != 2 && OsVersion.IS_UNIX) {
                Debug.trace("making file executable (setting executable flag)");
                String[] params = new String[]{"/bin/chmod", permissions, file.toString()};
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    handler.emitError("file execution error", "Error executing \n" + params[0] + " " + params[1] + " " + params[2]);
                    continue;
                }
            }
            if (exitStatus == 0 && (currentStage == 0 && efile.executionStage == 0 || currentStage == 2 && efile.executionStage == 2)) {
                ArrayList<String> paramList = new ArrayList<String>();
                if (0 == efile.type) {
                    paramList.add(file.toString());
                } else if (1 == efile.type && null == efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-jar");
                    paramList.add(file.toString());
                } else if (1 == efile.type && null != efile.mainClass) {
                    paramList.add(System.getProperty("java.home") + "/bin/java");
                    paramList.add("-cp");
                    try {
                        paramList.add(this.buildClassPath(file.toString()));
                    }
                    catch (Exception e) {
                        exitStatus = -1;
                        Debug.error(e);
                    }
                    paramList.add(efile.mainClass);
                }
                if (null != efile.argList && !efile.argList.isEmpty()) {
                    paramList.addAll(efile.argList);
                }
                String[] params = new String[paramList.size()];
                for (int i = 0; i < paramList.size(); ++i) {
                    params[i] = (String)paramList.get(i);
                }
                exitStatus = this.executeCommand(params, output);
                if (exitStatus != 0) {
                    deleteAfterwards = false;
                    String message = output[0] + "\n" + output[1];
                    if (message.length() == 1) {
                        message = "Failed to execute " + file.toString() + ".";
                    }
                    if (efile.onFailure == 0) {
                        handler.emitError("file execution error", message);
                    } else if (efile.onFailure == 1) {
                        handler.emitWarning("file execution error", message);
                        exitStatus = 0;
                    } else if (efile.onFailure == 3) {
                        exitStatus = 0;
                    } else if (handler.askQuestion("Execution Failed", message + "\nContinue Installation?", 37) == 47) {
                        exitStatus = 0;
                    }
                }
            }
            if (efile.executionStage != 0 || !deleteAfterwards || !file.canWrite()) continue;
            file.delete();
        }
        return exitStatus;
    }

    private String buildClassPath(String targetFile) throws Exception {
        StringBuffer classPath = new StringBuffer();
        ArrayList<String> jars = new ArrayList<String>();
        String rawClassPath = targetFile.replace(':', File.pathSeparatorChar).replace(';', File.pathSeparatorChar);
        String[] rawJars = rawClassPath.split("" + File.pathSeparatorChar);
        for (int i = 0; i < rawJars.length; ++i) {
            String[] subDirJars;
            File file = new File(rawJars[i]);
            jars.add(rawJars[i]);
            if (!file.isDirectory() || (subDirJars = FileUtil.getFileNames(rawJars[i], new FilenameFilter(){

                public boolean accept(File dir, String name) {
                    return name.toLowerCase().endsWith(FileExecutor.JAR_FILE_SUFFIX);
                }
            })) == null) continue;
            for (int j = 0; j < subDirJars.length; ++j) {
                jars.add(rawJars[i] + File.separator + subDirJars[j]);
            }
        }
        Iterator iter = jars.iterator();
        if (iter.hasNext()) {
            classPath.append(iter.next());
        }
        while (iter.hasNext()) {
            classPath.append(File.pathSeparatorChar).append(iter.next());
        }
        return classPath.toString();
    }
}

