/*
 * Decompiled with CFR 0.152.
 */
package com.izforge.izpack.util;

import com.izforge.izpack.installer.InstallData;
import com.izforge.izpack.panels.PasswordGroup;
import com.izforge.izpack.panels.ProcessingClient;
import com.izforge.izpack.panels.Validator;
import com.izforge.izpack.util.VariableSubstitutor;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class PasswordKeystoreValidator
implements Validator {
    public boolean validate(ProcessingClient client) {
        boolean returnValue = false;
        String keystorePassword = null;
        String keystoreFile = null;
        String keystoreType = "JKS";
        String skipValidation = null;
        String alias = null;
        String aliasPassword = null;
        Map params = this.getParams(client);
        try {
            if (params != null) {
                skipValidation = (String)params.get("skipValidation");
                System.out.println("skipValidation = " + skipValidation);
                if (skipValidation != null && skipValidation.equalsIgnoreCase("true")) {
                    System.out.println("Not validating keystore");
                    return true;
                }
                keystorePassword = (String)params.get("keystorePassword");
                if (keystorePassword == null) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter null, using validator password for keystore");
                } else if (keystorePassword.equalsIgnoreCase("")) {
                    keystorePassword = this.getPassword(client);
                    System.out.println("keystorePassword parameter empty, using validator password for keystore");
                }
                aliasPassword = (String)params.get("aliasPassword");
                if (aliasPassword == null) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter null, using validator password for key");
                } else if (aliasPassword.equalsIgnoreCase("")) {
                    aliasPassword = this.getPassword(client);
                    System.out.println("aliasPassword parameter empty, using validator password for key");
                }
                keystoreType = (String)params.get("keystoreType");
                if (keystoreFile == null) {
                    keystoreType = "JKS";
                    System.out.println("keystoreType parameter null, using default of JKS");
                } else if (keystorePassword.equalsIgnoreCase("")) {
                    keystoreType = "JKS";
                    System.out.println("keystoreType parameter empty, using default of JKS");
                }
                keystoreFile = (String)params.get("keystoreFile");
                if (keystoreFile != null) {
                    System.out.println("Attempting to open keystore: " + keystoreFile);
                    KeyStore ks = PasswordKeystoreValidator.getKeyStore(keystoreFile, keystoreType, keystorePassword.toCharArray());
                    if (ks != null) {
                        returnValue = true;
                        System.out.println("keystore password validated");
                        alias = (String)params.get("keystoreAlias");
                        if (alias != null) {
                            returnValue = ks.containsAlias(alias);
                            if (returnValue) {
                                System.out.println("keystore alias '" + alias + "' found, trying to retrieve");
                                try {
                                    ks.getKey(alias, aliasPassword.toCharArray());
                                    System.out.println("keystore alias '" + alias + "' validated");
                                }
                                catch (Exception e) {
                                    System.out.println("keystore alias validation failed: " + e);
                                    returnValue = false;
                                }
                            } else {
                                System.out.println("keystore alias '" + alias + "' not found");
                            }
                        }
                    }
                } else {
                    System.out.println("keystoreFile param not provided");
                }
            } else {
                System.out.println("params not provided");
            }
        }
        catch (Exception e) {
            System.out.println("validate() Failed: " + e);
        }
        return returnValue;
    }

    private Map getParams(ProcessingClient client) {
        HashMap<String, String> returnValue = null;
        PasswordGroup group = null;
        InstallData idata = this.getIdata(client);
        VariableSubstitutor vs = new VariableSubstitutor(idata.getVariables());
        try {
            group = (PasswordGroup)client;
            if (group.hasParams()) {
                Map params = group.getValidatorParams();
                returnValue = new HashMap<String, String>();
                Iterator keys = params.keySet().iterator();
                while (keys.hasNext()) {
                    String key = (String)keys.next();
                    String value = vs.substitute((String)params.get(key), null);
                    returnValue.put(key, value);
                }
            }
        }
        catch (Exception e) {
            System.out.println("getParams() Failed: " + e);
        }
        return returnValue;
    }

    private InstallData getIdata(ProcessingClient client) {
        PasswordGroup group = null;
        InstallData idata = null;
        try {
            group = (PasswordGroup)client;
            idata = group.getIdata();
        }
        catch (Exception e) {
            System.out.println("getIdata() Failed: " + e);
        }
        return idata;
    }

    private String getPassword(ProcessingClient client) {
        return client.getFieldContents(0);
    }

    public static KeyStore getKeyStore(String fileName, String type, char[] password) {
        KeyStore ks = null;
        try {
            ks = KeyStore.getInstance(type);
            ks.load(new FileInputStream(fileName), password);
        }
        catch (Exception e) {
            System.out.println("getKeyStore() Failed: " + e);
            ks = null;
        }
        return ks;
    }
}

