/*
 * Decompiled with CFR 0.152.
 */
package net.n3.nanoxml;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Stack;
import java.util.Vector;
import net.n3.nanoxml.IXMLReader;
import net.n3.nanoxml.NonValidator;
import net.n3.nanoxml.StdXMLBuilder;
import net.n3.nanoxml.StdXMLParser;
import net.n3.nanoxml.StdXMLReader;
import net.n3.nanoxml.XMLBuilderFactory;
import net.n3.nanoxml.XMLElement;
import net.n3.nanoxml.XMLException;
import net.n3.nanoxml.XMLParseException;

public class XIncludeXMLBuilder
extends StdXMLBuilder {
    public static final String INCLUDE_NS = "http://www.w3.org/2001/XInclude";
    public static final String INCLUDE_ELEMENT = "xinclude";
    public static final String HREF_ATTRIB = "href";
    public static final String XPOINTER_ATTRIB = "xpointer";
    public static final String ENCODING_ATTRIB = "encoding";
    public static final String ACCEPT_ENCODING = "accept";
    public static final String FALLBACK_ELEMENT = "xfallback";
    public static final String PARSE_ATTRIB = "parse";
    public static final String FRAGMENT_NS = "http://izpack.org/izpack/fragment";
    public static final String FRAGMENT = "xfragment";

    public void endElement(String name, String nsPrefix, String nsSystemID) {
        XMLElement element = this.getCurrentElement();
        super.endElement(name, nsPrefix, nsSystemID);
        this.processXInclude(element);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void processXInclude(XMLElement element) {
        if (!INCLUDE_ELEMENT.equals(element.getName())) return;
        Vector fallbackChildren = element.getChildrenNamed(FALLBACK_ELEMENT);
        if (element.getChildrenCount() != fallbackChildren.size() || fallbackChildren.size() > 1) {
            throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), "xinclude can optionally have a single xfragment as a child"));
        }
        boolean usingFallback = false;
        String href = element.getAttribute(HREF_ATTRIB, "");
        if (!href.equals("")) {
            IXMLReader reader = null;
            try {
                reader = this.getReader(element);
            }
            catch (Exception e) {
                reader = this.handleFallback(element);
                usingFallback = true;
            }
            String parse = element.getAttribute(PARSE_ATTRIB, "xml");
            if ("text".equals(parse) && !usingFallback) {
                this.includeText(element, reader);
                return;
            } else {
                if (!"xml".equals(parse)) throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), "parse attribute of xinclude must be \"xml\" or \"text\" but was " + parse));
                this.includeXML(element, reader);
            }
            return;
        }
        if (element.hasAttribute(XPOINTER_ATTRIB)) return;
        throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), "xpointermust be specified if href is empty or missing"));
    }

    private IXMLReader handleFallback(XMLElement include) {
        Vector fallbackChildren = include.getChildrenNamed(FALLBACK_ELEMENT);
        if (fallbackChildren.size() == 1) {
            XMLElement fallback = (XMLElement)fallbackChildren.get(0);
            String content = fallback.getContent();
            if (content != null) {
                content = content.trim();
            }
            if ("".equals(content) || content == null) {
                content = "<?xml version=\"1.0\" encoding=\"iso-8859-1\" standalone=\"yes\" ?><xfragment/>";
            }
            return StdXMLReader.stringReader(content);
        }
        throw new RuntimeException(new XMLParseException(include.getSystemID(), include.getLineNr(), "could not load content"));
    }

    private void includeXML(XMLElement element, IXMLReader reader) {
        try {
            Stack stack = this.getStack();
            StdXMLParser parser = new StdXMLParser();
            parser.setBuilder(XMLBuilderFactory.createXMLBuilder());
            parser.setReader(reader);
            parser.setValidator(new NonValidator());
            XMLElement childroot = (XMLElement)parser.parse();
            if (stack.isEmpty()) {
                this.setRootElement(childroot);
            } else {
                XMLElement parent = (XMLElement)stack.peek();
                parent.removeChild(element);
                if (FRAGMENT.equals(childroot.getName())) {
                    Vector grandchildren = childroot.getChildren();
                    Iterator it = grandchildren.iterator();
                    while (it.hasNext()) {
                        XMLElement grandchild = (XMLElement)it.next();
                        parent.addChild(grandchild);
                    }
                } else {
                    parent.addChild(childroot);
                }
            }
        }
        catch (XMLException e) {
            throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), e.getMessage()));
        }
    }

    private void includeText(XMLElement element, IXMLReader reader) {
        if (element.getAttribute(XPOINTER_ATTRIB) != null) {
            throw new RuntimeException(new XMLParseException("xpointer cannot be used with parse='text'"));
        }
        Stack stack = this.getStack();
        if (stack.isEmpty()) {
            throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), "cannot include text as the root node"));
        }
        XMLElement parent = (XMLElement)stack.peek();
        parent.removeChild(element);
        StringBuffer buffer = new StringBuffer();
        try {
            while (!reader.atEOF()) {
                buffer.append(reader.read());
            }
        }
        catch (IOException e) {
            throw new RuntimeException(new XMLParseException(element.getSystemID(), element.getLineNr(), e.getMessage()));
        }
        if (parent.getChildrenCount() == 0) {
            parent.setContent(buffer.toString());
        } else {
            XMLElement content = new XMLElement();
            content.setContent(buffer.toString());
            parent.addChild(content);
        }
    }

    private IXMLReader getReader(XMLElement element) throws XMLParseException, IOException {
        String href = element.getAttribute(HREF_ATTRIB);
        URL url = null;
        try {
            url = new URL(href);
        }
        catch (MalformedURLException e) {
            try {
                url = href.charAt(0) == '/' ? new URL("file://" + href) : new URL(new URL(element.getSystemID()), href);
            }
            catch (MalformedURLException e1) {
                new XMLParseException(element.getSystemID(), element.getLineNr(), "malformed url '" + href + "'");
            }
        }
        URLConnection connection = url.openConnection();
        if (connection instanceof HttpURLConnection && element.hasAttribute(ENCODING_ATTRIB)) {
            connection.setRequestProperty(ACCEPT_ENCODING, element.getAttribute(ENCODING_ATTRIB));
        }
        InputStream is = connection.getInputStream();
        InputStreamReader reader = null;
        reader = element.getAttribute(PARSE_ATTRIB, "xml").equals("text") && element.hasAttribute(ENCODING_ATTRIB) ? new InputStreamReader(is, element.getAttribute(ENCODING_ATTRIB, "")) : new InputStreamReader(is);
        StdXMLReader ireader = new StdXMLReader(reader);
        ireader.setSystemID(url.toExternalForm());
        return ireader;
    }

    public void startBuilding(String systemID, int lineNr) {
        super.startBuilding(systemID, lineNr);
    }
}

